/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import java.util.HashMap;
import java.util.Map;
import org.apache.directory.shared.ldap.filter.AssertionType;
import org.apache.directory.shared.ldap.filter.ExprNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExprNode
implements ExprNode {
    protected Map<String, Object> annotations;
    protected final AssertionType assertionType;

    protected AbstractExprNode(AssertionType assertionType) {
        this.assertionType = assertionType;
    }

    @Override
    public AssertionType getAssertionType() {
        return this.assertionType;
    }

    @Override
    public abstract boolean isLeaf();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractExprNode)) {
            return false;
        }
        AbstractExprNode that = (AbstractExprNode)o;
        if (this.assertionType != that.assertionType) {
            return false;
        }
        if (this.annotations == null) {
            return that.annotations == null;
        }
        if (that.annotations == null) {
            return false;
        }
        for (String key : this.annotations.keySet()) {
            if (!that.annotations.containsKey(key)) {
                return false;
            }
            Object thisAnnotation = this.annotations.get(key);
            Object thatAnnotation = that.annotations.get(key);
            if (!(thisAnnotation == null ? thatAnnotation != null : !thisAnnotation.equals(thatAnnotation))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 37;
        if (this.annotations != null) {
            for (String key : this.annotations.keySet()) {
                Object value = this.annotations.get(key);
                h = h * 17 + key.hashCode();
                h = h * 17 + (value == null ? 0 : value.hashCode());
            }
        }
        return h;
    }

    @Override
    public Object get(Object key) {
        if (null == this.annotations) {
            return null;
        }
        return this.annotations.get(key);
    }

    @Override
    public void set(String key, Object value) {
        if (null == this.annotations) {
            this.annotations = new HashMap<String, Object>(2);
        }
        this.annotations.put(key, value);
    }

    protected Map<String, Object> getAnnotations() {
        return this.annotations;
    }

    @Override
    public StringBuilder printRefinementToBuffer(StringBuilder buf) {
        throw new UnsupportedOperationException("ScopeNode can't be part of a refinement");
    }

    @Override
    public ExprNode clone() {
        try {
            ExprNode clone = (ExprNode)super.clone();
            if (this.annotations != null) {
                for (String key : this.annotations.keySet()) {
                    Object value = this.annotations.get(key);
                    ((AbstractExprNode)clone).annotations.put(key, value);
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public String toString() {
        if (null != this.annotations && this.annotations.containsKey("count")) {
            return ":[" + this.annotations.get("count") + "]";
        }
        return "";
    }
}

