/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.client.DefaultClientEntry;
import org.apache.directory.shared.ldap.message.AbstractAbandonableRequest;
import org.apache.directory.shared.ldap.message.AddRequest;
import org.apache.directory.shared.ldap.message.AddResponse;
import org.apache.directory.shared.ldap.message.AddResponseImpl;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ResultResponse;
import org.apache.directory.shared.ldap.name.LdapDN;

public class AddRequestImpl
extends AbstractAbandonableRequest
implements AddRequest {
    static final long serialVersionUID = 7534132448349520346L;
    private Entry entry = new DefaultClientEntry();
    private AddResponse response;

    public AddRequestImpl(int id) {
        super(id, TYPE);
    }

    public LdapDN getEntryDn() {
        return this.entry.getDn();
    }

    public void setEntryDn(LdapDN dn) {
        this.entry.setDn(dn);
    }

    public Entry getEntry() {
        return this.entry;
    }

    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    public ResultResponse getResultResponse() {
        if (this.response == null) {
            this.response = new AddResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AddRequest)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AddRequest req = (AddRequest)obj;
        if (this.entry == null) {
            return req.getEntry() == null;
        }
        return this.entry.equals(req.getEntry());
    }

    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + (this.entry == null ? 0 : this.entry.hashCode());
        hash = hash * 17 + (this.response == null ? 0 : this.response.hashCode());
        hash = hash * 17 + super.hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Add Request :\n");
        if (this.entry == null) {
            sb.append("            No entry\n");
        } else {
            sb.append(this.entry.toString());
        }
        return sb.toString();
    }
}

