/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.modify;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientModification;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyRequest
extends LdapMessage {
    private static final Logger LOG = LoggerFactory.getLogger(ModifyRequest.class);
    private LdapDN object;
    private List<Modification> modifications;
    private EntryAttribute currentAttribute;
    private ModificationOperation currentOperation;
    private int modifyRequestLength;
    private int modificationsLength;
    private List<Integer> modificationSequenceLength;
    private List<Integer> modificationLength;
    private List<Integer> valuesLength;

    @Override
    public int getMessageType() {
        return 13;
    }

    public void initModifications() {
        this.modifications = new ArrayList<Modification>();
    }

    public List<Modification> getModifications() {
        return this.modifications;
    }

    public void addModification(int operation) {
        this.currentOperation = ModificationOperation.getOperation(operation);
        if (this.currentAttribute == null) {
            this.modifications = new ArrayList<Modification>();
        }
    }

    public void addAttributeTypeAndValues(String type) {
        this.currentAttribute = new DefaultClientAttribute(StringTools.lowerCaseAscii(type));
        ClientModification modification = new ClientModification(this.currentOperation, this.currentAttribute);
        this.modifications.add(modification);
    }

    public void addAttributeValue(String value) {
        this.currentAttribute.add(value);
    }

    public void addAttributeValue(Value<?> value) {
        this.currentAttribute.add(value);
    }

    public void addAttributeValue(byte[] value) {
        this.currentAttribute.add(new byte[][]{value});
    }

    public String getCurrentAttributeType() {
        return this.currentAttribute.getId();
    }

    public LdapDN getObject() {
        return this.object;
    }

    public void setObject(LdapDN object) {
        this.object = object;
    }

    public int getCurrentOperation() {
        return this.currentOperation.getValue();
    }

    public void setCurrentOperation(int currentOperation) {
        this.currentOperation = ModificationOperation.getOperation(currentOperation);
    }

    public void setCurrentOperation(ModificationOperation currentOperation) {
        this.currentOperation = currentOperation;
    }

    @Override
    public int computeLength() {
        this.modifyRequestLength = 1 + TLV.getNbBytes((int)LdapDN.getNbBytes(this.object)) + LdapDN.getNbBytes(this.object);
        this.modificationsLength = 0;
        if (this.modifications != null && this.modifications.size() != 0) {
            this.modificationSequenceLength = new LinkedList<Integer>();
            this.modificationLength = new LinkedList<Integer>();
            this.valuesLength = new LinkedList<Integer>();
            for (Modification modification : this.modifications) {
                int localModificationSequenceLength = 3;
                int localValuesLength = 0;
                int typeLength = modification.getAttribute().getId().length();
                int localModificationLength = 1 + TLV.getNbBytes((int)typeLength) + typeLength;
                if (modification.getAttribute().size() != 0) {
                    for (Value value : modification.getAttribute()) {
                        if (value instanceof ClientStringValue) {
                            int valueLength = StringTools.getBytesUtf8((String)value.get()).length;
                            localValuesLength += 1 + TLV.getNbBytes((int)valueLength) + valueLength;
                            continue;
                        }
                        localValuesLength += 1 + TLV.getNbBytes((int)((byte[])value.getReference()).length) + ((byte[])value.getReference()).length;
                    }
                }
                this.modificationsLength += 1 + TLV.getNbBytes((int)(localModificationSequenceLength += 1 + TLV.getNbBytes((int)(localModificationLength += 1 + TLV.getNbBytes((int)localValuesLength) + localValuesLength)) + localModificationLength)) + localModificationSequenceLength;
                this.valuesLength.add(localValuesLength);
                this.modificationLength.add(localModificationLength);
                this.modificationSequenceLength.add(localModificationSequenceLength);
            }
            this.modifyRequestLength += 1 + TLV.getNbBytes((int)this.modificationsLength) + this.modificationsLength;
        }
        return 1 + TLV.getNbBytes((int)this.modifyRequestLength) + this.modifyRequestLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)102);
            buffer.put(TLV.getBytes((int)this.modifyRequestLength));
            org.apache.directory.shared.asn1.ber.tlv.Value.encode((ByteBuffer)buffer, (byte[])LdapDN.getBytes(this.object));
            buffer.put((byte)48);
            buffer.put(TLV.getBytes((int)this.modificationsLength));
            if (this.modifications != null && this.modifications.size() != 0) {
                int modificationNumber = 0;
                for (Modification modification : this.modifications) {
                    buffer.put((byte)48);
                    int localModificationSequenceLength = this.modificationSequenceLength.get(modificationNumber);
                    buffer.put(TLV.getBytes((int)localModificationSequenceLength));
                    buffer.put((byte)10);
                    buffer.put((byte)1);
                    buffer.put((byte)modification.getOperation().getValue());
                    buffer.put((byte)48);
                    int localModificationLength = this.modificationLength.get(modificationNumber);
                    buffer.put(TLV.getBytes((int)localModificationLength));
                    org.apache.directory.shared.asn1.ber.tlv.Value.encode((ByteBuffer)buffer, (String)modification.getAttribute().getId());
                    buffer.put((byte)49);
                    int localValuesLength = this.valuesLength.get(modificationNumber);
                    buffer.put(TLV.getBytes((int)localValuesLength));
                    if (modification.getAttribute().size() != 0) {
                        for (Value value : modification.getAttribute()) {
                            if (value instanceof ClientStringValue) {
                                org.apache.directory.shared.asn1.ber.tlv.Value.encode((ByteBuffer)buffer, (String)((String)value.get()));
                                continue;
                            }
                            org.apache.directory.shared.asn1.ber.tlv.Value.encode((ByteBuffer)buffer, (byte[])((byte[])value.getReference()));
                        }
                    }
                    ++modificationNumber;
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Modify Request\n");
        sb.append("        Object : '").append(this.object).append("'\n");
        if (this.modifications != null) {
            int i = 0;
            for (Modification modification : this.modifications) {
                sb.append("            Modification[").append(i).append("]\n");
                sb.append("                Operation : ");
                if (modification != null) {
                    switch (modification.getOperation()) {
                        case ADD_ATTRIBUTE: {
                            sb.append(" add\n");
                            break;
                        }
                        case REPLACE_ATTRIBUTE: {
                            sb.append(" replace\n");
                            break;
                        }
                        case REMOVE_ATTRIBUTE: {
                            sb.append(" delete\n");
                        }
                    }
                    sb.append("                Modification\n");
                    EntryAttribute attribute = modification.getAttribute();
                    if (attribute == null) continue;
                    sb.append(attribute);
                    continue;
                }
                sb.append(" unknown modification operation\n");
            }
        }
        return sb.toString();
    }
}

