/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.add.AddRequest;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(ValueAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public ValueAction() {
        super("Store a value");
    }

    public void action(IAsn1Container container) {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
        AddRequest addRequest = ldapMessage.getAddRequest();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        Object value = null;
        if (tlv.getLength() == 0) {
            addRequest.addAttributeValue("");
        } else {
            if (ldapMessageContainer.isBinary(addRequest.getCurrentAttributeType())) {
                value = tlv.getValue().getData();
                if (IS_DEBUG) {
                    log.debug("Adding value {}", (Object)StringTools.dumpBytes(value));
                }
            } else {
                value = StringTools.utf8ToString(tlv.getValue().getData());
                log.debug("Adding value {}" + value);
            }
            addRequest.addAttributeValue(value);
        }
        ldapMessageContainer.grammarEndAllowed(true);
    }
}

