/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.shared.ldap.name.AtavSerializer;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdnSerializer {
    protected static final Logger LOG = LoggerFactory.getLogger(RdnSerializer.class);

    public static void serialize(Rdn rdn, ObjectOutput out) throws IOException {
        out.writeInt(rdn.getNbAtavs());
        out.writeUTF(rdn.getUpName());
        out.writeUTF(rdn.getNormName());
        out.writeInt(rdn.getStart());
        out.writeInt(rdn.getLength());
        switch (rdn.getNbAtavs()) {
            case 0: {
                break;
            }
            case 1: {
                AtavSerializer.serialize(rdn.getAtav(), out);
                break;
            }
            default: {
                for (AttributeTypeAndValue atav : rdn) {
                    AtavSerializer.serialize(atav, out);
                }
            }
        }
        out.flush();
    }

    public static Rdn deserialize(ObjectInput in) throws IOException {
        int nbAtavs = in.readInt();
        String upName = in.readUTF();
        String normName = in.readUTF();
        if (StringTools.isEmpty(normName)) {
            normName = upName;
        }
        int start = in.readInt();
        int length = in.readInt();
        Rdn rdn = new Rdn(length, start, upName, normName);
        switch (nbAtavs) {
            case 0: {
                return rdn;
            }
            case 1: {
                AttributeTypeAndValue atav = AtavSerializer.deserialize(in);
                rdn.addAttributeTypeAndValue(atav);
                return rdn;
            }
        }
        for (int i = 0; i < nbAtavs; ++i) {
            AttributeTypeAndValue atav = AtavSerializer.deserialize(in);
            rdn.addAttributeTypeAndValue(atav);
        }
        return rdn;
    }
}

