/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import org.apache.directory.shared.ldap.filter.AbstractExprNode;
import org.apache.directory.shared.ldap.filter.AssertionType;
import org.apache.directory.shared.ldap.filter.FilterVisitor;
import org.apache.directory.shared.ldap.message.AliasDerefMode;

public class ScopeNode
extends AbstractExprNode {
    private final int scope;
    private final String baseDn;
    private final AliasDerefMode aliasDerefAliases;

    public ScopeNode(AliasDerefMode aliasDerefAliases, String baseDn, int scope) {
        super(AssertionType.SCOPE);
        this.scope = scope;
        this.baseDn = baseDn;
        this.aliasDerefAliases = aliasDerefAliases;
    }

    public boolean isLeaf() {
        return true;
    }

    public int getScope() {
        return this.scope;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public AliasDerefMode getDerefAliases() {
        return this.aliasDerefAliases;
    }

    public Object accept(FilterVisitor visitor) {
        if (visitor.canVisit(this)) {
            return visitor.visit(this);
        }
        return null;
    }

    public int hashCode() {
        int h = 37;
        h = h * 17 + super.hashCode();
        h = h * 17 + (this.aliasDerefAliases != null ? this.aliasDerefAliases.hashCode() : 0);
        h = h * 17 + (this.baseDn != null ? this.baseDn.hashCode() : 0);
        h = h * 17 + this.scope;
        return h;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(#{");
        switch (this.scope) {
            case 0: {
                buf.append("OBJECT_SCOPE");
                break;
            }
            case 1: {
                buf.append("ONE_LEVEL_SCOPE");
                break;
            }
            case 2: {
                buf.append("SUBTREE_SCOPE (Estimated)");
                break;
            }
            default: {
                buf.append("UNKNOWN");
            }
        }
        buf.append(", '");
        buf.append(this.baseDn);
        buf.append("', ");
        buf.append((Object)this.aliasDerefAliases);
        buf.append("}");
        buf.append(super.toString());
        buf.append(')');
        return buf.toString();
    }
}

