/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import java.io.IOException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.util.AttributeSerializerUtils;

public class AttributesSerializerUtils {
    private static final long serialVersionUID = -3756830073760754086L;
    private static final byte SEPARATOR = -1;

    public static final Object deserialize(byte[] buf) {
        if (buf.length == 0) {
            return new AttributesImpl();
        }
        AttributesImpl attrs = new AttributesImpl();
        for (int pos = 0; pos < buf.length; ++pos) {
            Object value;
            String id = AttributeSerializerUtils.readString(buf, pos);
            AttributeImpl attr = new AttributeImpl(id);
            if (buf[pos += (id.length() << 1) + 4] == 0) {
                ++pos;
                while (pos < buf.length && buf[pos] != -1) {
                    value = AttributeSerializerUtils.readString(buf, pos);
                    pos += (((String)value).length() << 1) + 4;
                    attr.add(value);
                }
            } else {
                ++pos;
                while (pos < buf.length && buf[pos] != -1) {
                    value = AttributeSerializerUtils.readBytes(buf, pos);
                    pos += ((Object)value).length + 4;
                    attr.add(value);
                }
            }
            attrs.put(attr);
        }
        return attrs;
    }

    public static final byte[] serialize(Object attrsObj) throws IOException {
        Attributes attrs = (Attributes)attrsObj;
        byte[] buf = new byte[AttributesSerializerUtils.calculateSize(attrs)];
        int pos = 0;
        try {
            NamingEnumeration<? extends Attribute> ii = attrs.getAll();
            while (ii.hasMore()) {
                Object value;
                NamingEnumeration<?> jj;
                Attribute attr = ii.next();
                pos = AttributeSerializerUtils.write(buf, attr.getID(), pos);
                Object first = attr.get();
                if (first instanceof String) {
                    buf[pos] = 0;
                    ++pos;
                    jj = attr.getAll();
                    while (jj.hasMore()) {
                        value = (String)jj.next();
                        pos = AttributeSerializerUtils.write(buf, (String)value, pos);
                    }
                } else {
                    buf[pos] = 1;
                    ++pos;
                    jj = attr.getAll();
                    while (jj.hasMore()) {
                        value = (byte[])jj.next();
                        pos = AttributeSerializerUtils.write(buf, (byte[])value, pos);
                    }
                }
                if (!ii.hasMore()) continue;
                buf[pos] = -1;
                ++pos;
            }
        }
        catch (NamingException e) {
            IOException ioe = new IOException("Failed while accesssing attributes and/or their values.");
            ioe.initCause(e);
            throw ioe;
        }
        return buf;
    }

    private static final int calculateSize(Attributes attrs) throws IOException {
        int size = 0;
        try {
            NamingEnumeration<? extends Attribute> ii = attrs.getAll();
            while (ii.hasMore()) {
                Attribute attr = ii.next();
                if (ii.hasMore()) {
                    size += AttributeSerializerUtils.calculateSize(attr) + 1;
                    continue;
                }
                size += AttributeSerializerUtils.calculateSize(attr);
            }
        }
        catch (NamingException e) {
            IOException ioe = new IOException("Failed while accesssing attributes.");
            ioe.initCause(e);
            throw ioe;
        }
        return size;
    }
}

