/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.syntaxCheckers;

import org.apache.directory.shared.ldap.model.schema.SyntaxChecker;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(NumberSyntaxChecker.class);

    public NumberSyntaxChecker() {
        super("1.3.6.1.4.1.18060.0.4.0.0.4");
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        block3: for (int i = 0; i < strValue.length(); ++i) {
            switch (strValue.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block3;
                }
                default: {
                    LOG.debug("Syntax invalid for '{}'", value);
                    return false;
                }
            }
        }
        if (strValue.charAt(0) == '0' && strValue.length() > 1) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        LOG.debug("Syntax valid for '{}'", value);
        return true;
    }
}

