/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.syntaxCheckers;

import org.apache.directory.shared.ldap.model.schema.SyntaxChecker;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ia5StringSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(Ia5StringSyntaxChecker.class);

    public Ia5StringSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.26");
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return true;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        boolean result = Strings.isIA5String((String)strValue);
        if (result) {
            LOG.debug("Syntax valid for '{}'", value);
        } else {
            LOG.debug("Syntax invalid for '{}'", value);
        }
        return result;
    }
}

