/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.syntaxCheckers;

import org.apache.directory.shared.ldap.model.schema.SyntaxChecker;
import org.apache.directory.shared.util.Chars;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitStringSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(BitStringSyntaxChecker.class);

    public BitStringSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.6");
    }

    public static boolean isValid(String strValue) {
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", (Object)strValue);
            return false;
        }
        int pos = 0;
        if (!Strings.isCharASCII((String)strValue, (int)pos++, (char)'\'')) {
            LOG.debug("Syntax invalid for '{}'", (Object)strValue);
            return false;
        }
        if (!Chars.isBit((String)strValue, (int)pos++)) {
            LOG.debug("Syntax invalid for '{}'", (Object)strValue);
            return false;
        }
        while (Chars.isBit((String)strValue, (int)pos)) {
            ++pos;
        }
        if (!Strings.isCharASCII((String)strValue, (int)pos++, (char)'\'')) {
            LOG.debug("Syntax invalid for '{}'", (Object)strValue);
            return false;
        }
        if (!Strings.isCharASCII((String)strValue, (int)pos, (char)'B')) {
            LOG.debug("Syntax invalid for '{}'", (Object)strValue);
            return false;
        }
        LOG.debug("Syntax valid for '{}'", (Object)strValue);
        return true;
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        return BitStringSyntaxChecker.isValid(strValue);
    }
}

