/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.parsers;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.text.ParseException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.schema.parsers.AbstractSchemaParser;
import org.apache.directory.shared.ldap.model.schema.parsers.SyntaxCheckerDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyntaxCheckerDescriptionSchemaParser
extends AbstractSchemaParser {
    protected static final Logger LOG = LoggerFactory.getLogger(SyntaxCheckerDescriptionSchemaParser.class);

    public synchronized SyntaxCheckerDescription parseSyntaxCheckerDescription(String syntaxCheckerDescription) throws ParseException {
        LOG.debug("Parsing a SyntaxChecker : {}", (Object)syntaxCheckerDescription);
        if (syntaxCheckerDescription == null) {
            throw new ParseException("Null", 0);
        }
        this.reset(syntaxCheckerDescription);
        try {
            SyntaxCheckerDescription syntaxChecker = this.parser.syntaxCheckerDescription();
            SyntaxCheckerDescriptionSchemaParser.updateSchemaName(syntaxChecker);
            return syntaxChecker;
        }
        catch (RecognitionException re) {
            String msg = I18n.err((I18n)I18n.ERR_04259, (Object[])new Object[]{syntaxCheckerDescription, re.getMessage(), re.getColumn()});
            LOG.error(msg);
            throw new ParseException(msg, re.getColumn());
        }
        catch (TokenStreamException tse) {
            String msg = I18n.err((I18n)I18n.ERR_04260, (Object[])new Object[]{syntaxCheckerDescription, tse.getMessage()});
            LOG.error(msg);
            throw new ParseException(msg, 0);
        }
    }

    public SyntaxCheckerDescription parse(String schemaDescription) throws ParseException {
        return this.parseSyntaxCheckerDescription(schemaDescription);
    }
}

