/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.exception;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.exception.LdapOperationException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;

public class LdapInvalidDnException
extends LdapOperationException {
    static final long serialVersionUID = 1L;

    public LdapInvalidDnException(String message) {
        super(message);
    }

    public LdapInvalidDnException(String message, Throwable cause) {
        super(message, cause);
    }

    public LdapInvalidDnException(ResultCodeEnum resultCode, String message) {
        super(message);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    public LdapInvalidDnException(ResultCodeEnum resultCode, String message, Throwable cause) {
        super(message, cause);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    public LdapInvalidDnException(ResultCodeEnum resultCode) {
        super((String)null);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    private void checkResultCode(ResultCodeEnum resultCode) {
        switch (resultCode) {
            case INVALID_DN_SYNTAX: 
            case NAMING_VIOLATION: {
                return;
            }
        }
        throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04140_UNACCEPTABLE_RESUT_CODE, (Object[])new Object[]{resultCode}));
    }
}

