/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.controls.syncrepl_impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.ControlDecorator;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.extras.controls.SyncInfoValue;
import org.apache.directory.shared.ldap.extras.controls.SyncInfoValueImpl;
import org.apache.directory.shared.ldap.extras.controls.SynchronizationInfoEnum;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncInfoValueContainer;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncInfoValueTags;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncInfoValueDecorator
extends ControlDecorator<SyncInfoValue>
implements SyncInfoValue {
    private int syncUUIDsLength;
    private static final Asn1Decoder decoder = new Asn1Decoder();
    private int syncInfoValueLength;

    public SyncInfoValueDecorator(LdapApiService codec) {
        super(codec, (Control)new SyncInfoValueImpl());
    }

    public SyncInfoValueDecorator(LdapApiService codec, SyncInfoValue control) {
        super(codec, (Control)control);
    }

    public SyncInfoValueDecorator(LdapApiService codec, SynchronizationInfoEnum type) {
        this(codec);
        this.setType(type);
    }

    public SynchronizationInfoEnum getType() {
        return ((SyncInfoValue)this.getDecorated()).getType();
    }

    public void setType(SynchronizationInfoEnum type) {
        ((SyncInfoValue)this.getDecorated()).setType(type);
        if (type == SynchronizationInfoEnum.SYNC_ID_SET && ((SyncInfoValue)this.getDecorated()).getSyncUUIDs() == null) {
            ((SyncInfoValue)this.getDecorated()).setSyncUUIDs(new ArrayList());
        }
    }

    public byte[] getCookie() {
        return ((SyncInfoValue)this.getDecorated()).getCookie();
    }

    public void setCookie(byte[] cookie) {
        if (!Strings.isEmpty((byte[])cookie)) {
            byte[] copy = new byte[cookie.length];
            System.arraycopy(cookie, 0, copy, 0, cookie.length);
            ((SyncInfoValue)this.getDecorated()).setCookie(copy);
        } else {
            ((SyncInfoValue)this.getDecorated()).setCookie(null);
        }
    }

    public boolean isRefreshDone() {
        return ((SyncInfoValue)this.getDecorated()).isRefreshDone();
    }

    public void setRefreshDone(boolean refreshDone) {
        ((SyncInfoValue)this.getDecorated()).setRefreshDone(refreshDone);
    }

    public boolean isRefreshDeletes() {
        return ((SyncInfoValue)this.getDecorated()).isRefreshDeletes();
    }

    public void setRefreshDeletes(boolean refreshDeletes) {
        ((SyncInfoValue)this.getDecorated()).setRefreshDeletes(refreshDeletes);
    }

    public List<byte[]> getSyncUUIDs() {
        return ((SyncInfoValue)this.getDecorated()).getSyncUUIDs();
    }

    public void setSyncUUIDs(List<byte[]> syncUUIDs) {
        ((SyncInfoValue)this.getDecorated()).setSyncUUIDs(syncUUIDs);
    }

    public void addSyncUUID(byte[] syncUUID) {
        ((SyncInfoValue)this.getDecorated()).addSyncUUID(syncUUID);
    }

    public int computeLength() {
        this.syncInfoValueLength = 0;
        switch (this.getType()) {
            case NEW_COOKIE: {
                this.syncInfoValueLength = this.getCookie() != null ? 1 + TLV.getNbBytes((int)this.getCookie().length) + this.getCookie().length : 2;
                this.valueLength = this.syncInfoValueLength;
                return this.valueLength;
            }
            case REFRESH_DELETE: 
            case REFRESH_PRESENT: {
                if (this.getCookie() != null) {
                    this.syncInfoValueLength = 1 + TLV.getNbBytes((int)this.getCookie().length) + this.getCookie().length;
                }
                if (!this.isRefreshDone()) {
                    this.syncInfoValueLength += 3;
                }
                this.valueLength = 1 + TLV.getNbBytes((int)this.syncInfoValueLength) + this.syncInfoValueLength;
                return this.valueLength;
            }
            case SYNC_ID_SET: {
                if (this.getCookie() != null) {
                    this.syncInfoValueLength = 1 + TLV.getNbBytes((int)this.getCookie().length) + this.getCookie().length;
                }
                if (this.isRefreshDeletes()) {
                    this.syncInfoValueLength += 3;
                }
                this.syncUUIDsLength = 0;
                if (this.getSyncUUIDs().size() != 0) {
                    for (byte[] syncUUID : this.getSyncUUIDs()) {
                        int uuidLength = 1 + TLV.getNbBytes((int)syncUUID.length) + syncUUID.length;
                        this.syncUUIDsLength += uuidLength;
                    }
                }
                this.syncInfoValueLength += 1 + TLV.getNbBytes((int)this.syncUUIDsLength) + this.syncUUIDsLength;
                this.valueLength = 1 + TLV.getNbBytes((int)this.syncInfoValueLength) + this.syncInfoValueLength;
                return this.valueLength;
            }
        }
        return 1 + TLV.getNbBytes((int)this.syncInfoValueLength) + this.syncInfoValueLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04023, (Object[])new Object[0]));
        }
        switch (this.getType()) {
            case NEW_COOKIE: {
                buffer.put((byte)SyncInfoValueTags.NEW_COOKIE_TAG.getValue());
                if (this.getCookie() == null || this.getCookie().length == 0) {
                    buffer.put((byte)0);
                    break;
                }
                buffer.put(TLV.getBytes((int)this.getCookie().length));
                buffer.put(this.getCookie());
                break;
            }
            case REFRESH_DELETE: {
                buffer.put((byte)SyncInfoValueTags.REFRESH_DELETE_TAG.getValue());
                buffer.put(TLV.getBytes((int)this.syncInfoValueLength));
                if (this.getCookie() != null) {
                    Value.encode((ByteBuffer)buffer, (byte[])this.getCookie());
                }
                if (this.isRefreshDone()) break;
                Value.encode((ByteBuffer)buffer, (boolean)this.isRefreshDone());
                break;
            }
            case REFRESH_PRESENT: {
                buffer.put((byte)SyncInfoValueTags.REFRESH_PRESENT_TAG.getValue());
                buffer.put(TLV.getBytes((int)this.syncInfoValueLength));
                if (this.getCookie() != null) {
                    Value.encode((ByteBuffer)buffer, (byte[])this.getCookie());
                }
                if (this.isRefreshDone()) break;
                Value.encode((ByteBuffer)buffer, (boolean)this.isRefreshDone());
                break;
            }
            case SYNC_ID_SET: {
                buffer.put((byte)SyncInfoValueTags.SYNC_ID_SET_TAG.getValue());
                buffer.put(TLV.getBytes((int)this.syncInfoValueLength));
                if (this.getCookie() != null) {
                    Value.encode((ByteBuffer)buffer, (byte[])this.getCookie());
                }
                if (this.isRefreshDeletes()) {
                    Value.encode((ByteBuffer)buffer, (boolean)this.isRefreshDeletes());
                }
                buffer.put(UniversalTag.SET.getValue());
                buffer.put(TLV.getBytes((int)this.syncUUIDsLength));
                if (this.getSyncUUIDs().size() == 0) break;
                for (byte[] syncUUID : this.getSyncUUIDs()) {
                    Value.encode((ByteBuffer)buffer, (byte[])syncUUID);
                }
                break;
            }
        }
        return buffer;
    }

    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                switch (this.getType()) {
                    case NEW_COOKIE: {
                        buffer.put((byte)SyncInfoValueTags.NEW_COOKIE_TAG.getValue());
                        if (this.getCookie() == null || this.getCookie().length == 0) {
                            buffer.put((byte)0);
                            break;
                        }
                        buffer.put(TLV.getBytes((int)this.getCookie().length));
                        buffer.put(this.getCookie());
                        break;
                    }
                    case REFRESH_DELETE: {
                        buffer.put((byte)SyncInfoValueTags.REFRESH_DELETE_TAG.getValue());
                        buffer.put(TLV.getBytes((int)this.syncInfoValueLength));
                        if (this.getCookie() != null) {
                            Value.encode((ByteBuffer)buffer, (byte[])this.getCookie());
                        }
                        if (this.isRefreshDone()) break;
                        Value.encode((ByteBuffer)buffer, (boolean)this.isRefreshDone());
                        break;
                    }
                    case REFRESH_PRESENT: {
                        buffer.put((byte)SyncInfoValueTags.REFRESH_PRESENT_TAG.getValue());
                        buffer.put(TLV.getBytes((int)this.syncInfoValueLength));
                        if (this.getCookie() != null) {
                            Value.encode((ByteBuffer)buffer, (byte[])this.getCookie());
                        }
                        if (this.isRefreshDone()) break;
                        Value.encode((ByteBuffer)buffer, (boolean)this.isRefreshDone());
                        break;
                    }
                    case SYNC_ID_SET: {
                        buffer.put((byte)SyncInfoValueTags.SYNC_ID_SET_TAG.getValue());
                        buffer.put(TLV.getBytes((int)this.syncInfoValueLength));
                        if (this.getCookie() != null) {
                            Value.encode((ByteBuffer)buffer, (byte[])this.getCookie());
                        }
                        if (this.isRefreshDeletes()) {
                            Value.encode((ByteBuffer)buffer, (boolean)this.isRefreshDeletes());
                        }
                        buffer.put(UniversalTag.SET.getValue());
                        buffer.put(TLV.getBytes((int)this.syncUUIDsLength));
                        if (this.getSyncUUIDs().size() == 0) break;
                        for (byte[] syncUUID : this.getSyncUUIDs()) {
                            Value.encode((ByteBuffer)buffer, (byte[])syncUUID);
                        }
                        break;
                    }
                }
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(controlBytes);
        SyncInfoValueContainer container = new SyncInfoValueContainer(this.getCodecService(), this);
        decoder.decode(bb, (Asn1Container)container);
        return this;
    }
}

