/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.reponse;

import org.apache.directory.shared.dsmlv2.DsmlDecorator;
import org.apache.directory.shared.dsmlv2.ParserUtils;
import org.apache.directory.shared.dsmlv2.reponse.LdapResponseDecorator;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.codec.search.SearchResultEntryCodec;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.name.DN;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class SearchResultEntryDsml
extends LdapResponseDecorator
implements DsmlDecorator {
    public SearchResultEntryDsml() {
        super((LdapMessageCodec)new SearchResultEntryCodec());
    }

    public SearchResultEntryDsml(SearchResultEntryCodec ldapMessage) {
        super((LdapMessageCodec)ldapMessage);
    }

    public MessageTypeEnum getMessageType() {
        return this.instance.getMessageType();
    }

    public Element toDsml(Element root) {
        Element element = root.addElement("searchResultEntry");
        SearchResultEntryCodec searchResultEntry = (SearchResultEntryCodec)this.instance;
        element.addAttribute("dn", searchResultEntry.getObjectName().getName());
        Entry entry = searchResultEntry.getEntry();
        for (EntryAttribute attribute : entry) {
            Element attributeElement = element.addElement("attr");
            attributeElement.addAttribute("name", attribute.getId());
            for (Value value : attribute) {
                if (ParserUtils.needsBase64Encoding(value.get())) {
                    Namespace xsdNamespace = new Namespace("xsd", "http://www.w3c.org/2001/XMLSchema");
                    Namespace xsiNamespace = new Namespace("xsi", "http://www.w3c.org/2001/XMLSchema-instance");
                    attributeElement.getDocument().getRootElement().add(xsdNamespace);
                    attributeElement.getDocument().getRootElement().add(xsiNamespace);
                    Element valueElement = attributeElement.addElement("value").addText(ParserUtils.base64Encode(value.get()));
                    valueElement.addAttribute(new QName("type", xsiNamespace), "xsd:base64Binary");
                    continue;
                }
                attributeElement.addElement("value").addText(value.getString());
            }
        }
        return element;
    }

    public DN getObjectName() {
        return ((SearchResultEntryCodec)this.instance).getObjectName();
    }

    public void setObjectName(DN objectName) {
        ((SearchResultEntryCodec)this.instance).setObjectName(objectName);
    }

    public Entry getEntry() {
        return ((SearchResultEntryCodec)this.instance).getEntry();
    }

    public void setEntry(Entry entry) {
        ((SearchResultEntryCodec)this.instance).setEntry(entry);
    }

    public void addAttributeValues(String type) {
        ((SearchResultEntryCodec)this.instance).addAttributeValues(type);
    }

    public void addAttributeValue(Object value) {
        ((SearchResultEntryCodec)this.instance).addAttributeValue(value);
    }

    public String getCurrentAttributeValueType() {
        return ((SearchResultEntryCodec)this.instance).getCurrentAttributeValueType();
    }
}

