/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.util;

import java.io.UnsupportedEncodingException;

public class Asn1StringUtils {
    private static final byte[] HEX_CHAR = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public static String dumpByte(byte octet) {
        return new String(new byte[]{48, 120, HEX_CHAR[(octet & 0xF0) >> 4], HEX_CHAR[octet & 0xF]});
    }

    public static String dumpBytes(byte[] buffer) {
        if (buffer == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < buffer.length) {
            sb.append("0x").append((char)HEX_CHAR[(buffer[i] & 0xF0) >> 4]).append((char)HEX_CHAR[buffer[i] & 0xF]).append(" ");
            ++i;
        }
        return sb.toString();
    }

    public static byte[] getBytesUtf8(String string) {
        if (string == null) {
            return new byte[0];
        }
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return new byte[0];
        }
    }
}

