/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.ber.tlv;

import java.io.Serializable;

public class Length
implements Cloneable,
Serializable {
    public static final long serialVersionUID = 1L;
    public static final transient int LENGTH_LONG_FORM = 128;
    public static final transient int LENGTH_EXTENSION_RESERVED = 127;
    public static final transient int SHORT_MASK = 127;
    private int length = 0;
    private int size = 0;
    private transient int expectedLength = 1;
    private int currentLength = 0;
    private boolean definiteForm;

    public void reset() {
        this.length = 0;
        this.expectedLength = 0;
        this.currentLength = 0;
        this.size = 0;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getCurrentLength() {
        return this.currentLength;
    }

    public void setCurrentLength(int currentLength) {
        this.currentLength = currentLength;
    }

    public void incCurrentLength() {
        ++this.currentLength;
    }

    public int getExpectedLength() {
        return this.expectedLength;
    }

    public void setExpectedLength(int expectedLength) {
        this.expectedLength = expectedLength;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int getSize() {
        return this.size;
    }

    public void incSize() {
        ++this.size;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("LENGTH[").append(this.length).append("](").append(this.definiteForm ? "definite)" : "indefinite)").append("size=").append(this.size).append(")");
        return sb.toString();
    }

    public void setSize(int size) {
        this.size = size;
    }

    public static int getNbBytes(int length) {
        if (length >= 0) {
            if (length < 128) {
                return 1;
            }
            if (length < 256) {
                return 2;
            }
            if (length < 65536) {
                return 3;
            }
            if (length < 0x1000000) {
                return 4;
            }
            return 5;
        }
        return 5;
    }

    public static byte[] getBytes(int length) {
        byte[] bytes = new byte[Length.getNbBytes(length)];
        if (length >= 0) {
            if (length < 128) {
                bytes[0] = (byte)length;
            } else if (length < 256) {
                bytes[0] = -127;
                bytes[1] = (byte)length;
            } else if (length < 65536) {
                bytes[0] = -126;
                bytes[1] = (byte)(length >> 8);
                bytes[2] = (byte)(length & 0xFF);
            } else if (length < 0x1000000) {
                bytes[0] = -125;
                bytes[1] = (byte)(length >> 16);
                bytes[2] = (byte)(length >> 8 & 0xFF);
                bytes[3] = (byte)(length & 0xFF);
            } else {
                bytes[0] = -124;
                bytes[1] = (byte)(length >> 24);
                bytes[2] = (byte)(length >> 16 & 0xFF);
                bytes[3] = (byte)(length >> 8 & 0xFF);
                bytes[4] = (byte)(length & 0xFF);
            }
        } else {
            bytes[0] = -124;
            bytes[1] = (byte)(length >> 24);
            bytes[2] = (byte)(length >> 16 & 0xFF);
            bytes[3] = (byte)(length >> 8 & 0xFF);
            bytes[4] = (byte)(length & 0xFF);
        }
        return bytes;
    }

    public boolean isDefiniteForm() {
        return this.definiteForm;
    }

    public void setDefiniteForm(boolean definiteForm) {
        this.definiteForm = definiteForm;
    }
}

