/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.ber;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.tlv.ITLVBerDecoderMBean;
import org.apache.directory.shared.asn1.ber.tlv.Length;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Tag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.Asn1StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Asn1Decoder
implements ITLVBerDecoderMBean {
    private static final Logger log = LoggerFactory.getLogger((Class)Asn1Decoder.class);
    private static final boolean MORE = true;
    private static final boolean END = false;
    private boolean indefiniteLengthAllowed = false;
    private int maxLengthLength = 1;
    private int maxTagLength = 1;

    private boolean treatTagStartState(ByteBuffer stream, IAsn1Container container) throws DecoderException {
        if (stream.hasRemaining()) {
            byte octet = stream.get();
            TLV tlv = new TLV();
            Tag tag = tlv.getTag();
            tag.setSize(1);
            tag.setPrimitive((octet & 0x20) == 0);
            tag.setTypeClass(Tag.TYPE_CLASS[(octet & 0xC0) >>> 6]);
            int value = octet & 0x1F;
            if (value == 31) {
                if (tag.isUniversal()) {
                    throw new DecoderException("Universal tag 31 is reserved");
                }
                container.setState(1);
                tag.setId(0);
                tag.addByte(octet);
            } else {
                if (tag.isUniversal() && (value == 14 || value == 15)) {
                    throw new DecoderException("Universal tag " + value + " is reserved");
                }
                tag.setId(value);
                tag.addByte(octet);
                container.setState(2);
            }
            container.setCurrentTLV(tlv);
            return true;
        }
        return false;
    }

    private boolean treatTagPendingState(ByteBuffer stream, IAsn1Container container) throws DecoderException {
        if (stream.hasRemaining()) {
            Tag tag = container.getCurrentTLV().getTag();
            byte octet = stream.get();
            if (tag.getSize() >= 5) {
                container.setState(4);
                log.error("Tag label Overflow");
                throw new DecoderException("Tag label overflow");
            }
            byte val = (byte)(octet & 0x7F);
            tag.setId(tag.getId() << 7 | val);
            tag.incTagSize();
            if (val == octet) {
                container.setState(8);
            }
            return true;
        }
        return false;
    }

    private void dumpTLVTree(IAsn1Container container) {
        StringBuffer sb = new StringBuffer();
        TLV current = container.getCurrentTLV();
        sb.append("TLV").append(Asn1StringUtils.dumpByte(current.getTag().getTagBytes()[0])).append("(").append(current.getExpectedLength()).append(")");
        for (current = current.getParent(); current != null; current = current.getParent()) {
            sb.append("-TLV").append(Asn1StringUtils.dumpByte(current.getTag().getTagBytes()[0])).append("(").append(current.getExpectedLength()).append(")");
        }
        log.debug("TLV Tree : {}", (Object)sb.toString());
    }

    private boolean isTLVDecoded(IAsn1Container container) {
        TLV current = container.getCurrentTLV();
        for (TLV parent = current.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getExpectedLength() == 0) continue;
            return false;
        }
        Value value = current.getValue();
        if (value != null && value.getData() != null) {
            return current.getExpectedLength() == value.getData().length;
        }
        return current.getExpectedLength() == 0;
    }

    private void treatTagEndState(IAsn1Container container) throws DecoderException {
        if (log.isDebugEnabled()) {
            Tag tag = container.getCurrentTLV().getTag();
            log.debug("Tag {} has been decoded", (Object)tag.toString());
        }
        container.getCurrentTLV().setParent(container.getParentTLV());
        container.getGrammar().executeAction(container);
        container.setState(8);
    }

    private boolean treatLengthStartState(ByteBuffer stream, IAsn1Container container) throws DecoderException {
        if (stream.hasRemaining()) {
            byte octet = stream.get();
            Length length = container.getCurrentTLV().getLength();
            if ((octet & 0x80) == 0) {
                length.setLength(octet);
                length.setExpectedLength(0);
                length.setCurrentLength(0);
                length.setSize(1);
                container.setState(32);
            } else if ((octet & 0x7F) != 127) {
                int expectedLength = octet & 0x7F;
                if (expectedLength > 4) {
                    log.error("Overflow : can't have more than 4 bytes long length");
                    throw new DecoderException("Overflow : can't have more than 4 bytes long length");
                }
                length.setExpectedLength(expectedLength);
                length.setCurrentLength(0);
                length.setLength(0);
                length.setSize(1);
                container.setState(16);
            } else {
                log.error("Length reserved extension used");
                throw new DecoderException("Length reserved extension used");
            }
            return true;
        }
        return false;
    }

    private boolean treatLengthPendingState(ByteBuffer stream, IAsn1Container container) throws DecoderException {
        if (stream.hasRemaining()) {
            Length length = container.getCurrentTLV().getLength();
            while (length.getCurrentLength() < length.getExpectedLength()) {
                byte octet = stream.get();
                if (log.isDebugEnabled()) {
                    log.debug("  current byte : {}", (Object)Asn1StringUtils.dumpByte(octet));
                }
                length.incCurrentLength();
                length.incSize();
                length.setLength(length.getLength() << 8 | octet & 0xFF);
            }
            container.setState(32);
            return true;
        }
        return false;
    }

    private String getParentLength(TLV tlv) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TLV expected length stack : ");
        while (true) {
            if (tlv == null) break;
            buffer.append(" - ").append(tlv.getExpectedLength());
            tlv = tlv.getParent();
        }
        buffer.append(" - null");
        return buffer.toString();
    }

    private void treatLengthEndState(IAsn1Container container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        Length length = tlv.getLength();
        TLV parentTLV = container.getParentTLV();
        if (log.isDebugEnabled()) {
            log.debug("Parent length : {}", (Object)this.getParentLength(parentTLV));
        }
        if (parentTLV == null) {
            tlv.setExpectedLength(length.getLength());
            container.setParentTLV(tlv);
            if (log.isDebugEnabled()) {
                log.debug("Root TLV[{}]", (Object)new Integer(tlv.getLength().getLength()));
            }
        } else {
            int currentLength;
            int expectedLength = parentTLV.getExpectedLength();
            if (expectedLength < (currentLength = tlv.getSize())) {
                log.error("tlv[{}, {}]", (Object)new Integer(expectedLength), (Object)new Integer(currentLength));
                throw new DecoderException("The current Value length is above the expected length");
            }
            if (expectedLength == currentLength) {
                parentTLV.setExpectedLength(0);
                if (tlv.getTag().isConstructed()) {
                    if (tlv.getLength().getLength() == 0) {
                        while (parentTLV != null && parentTLV.getExpectedLength() == 0) {
                            parentTLV = parentTLV.getParent();
                        }
                        container.setParentTLV(parentTLV);
                    } else {
                        container.setParentTLV(tlv);
                    }
                    tlv.setParent(parentTLV);
                    tlv.setExpectedLength(tlv.getLength().getLength());
                } else {
                    tlv.setExpectedLength(tlv.getLength().getLength());
                    while (parentTLV != null && parentTLV.getExpectedLength() == 0) {
                        parentTLV = parentTLV.getParent();
                    }
                    container.setParentTLV(parentTLV);
                }
            } else {
                parentTLV.setExpectedLength(expectedLength - currentLength);
                tlv.setExpectedLength(tlv.getLength().getLength());
                if (tlv.getTag().isConstructed()) {
                    tlv.setParent(parentTLV);
                    container.setParentTLV(tlv);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Length {} has been decoded", (Object)length.toString());
        }
        if (length.getLength() == 0) {
            container.setState(512);
        } else {
            container.setState(64);
        }
    }

    private boolean treatValueStartState(ByteBuffer stream, IAsn1Container container) throws DecoderException {
        TLV currentTlv = container.getCurrentTLV();
        if (currentTlv.getTag().isConstructed()) {
            container.setState(512);
            return true;
        }
        int length = currentTlv.getLength().getLength();
        int nbBytes = stream.remaining();
        if (nbBytes < length) {
            currentTlv.getValue().init(length);
            currentTlv.getValue().setData(stream);
            container.setState(128);
            return false;
        }
        currentTlv.getValue().init(length);
        stream.get(currentTlv.getValue().getData(), 0, length);
        container.setState(512);
        return true;
    }

    private boolean treatValuePendingState(ByteBuffer stream, IAsn1Container container) throws DecoderException {
        int nbBytes;
        TLV currentTlv = container.getCurrentTLV();
        int length = currentTlv.getLength().getLength();
        int currentLength = currentTlv.getValue().getCurrentLength();
        if (currentLength + (nbBytes = stream.remaining()) < length) {
            currentTlv.getValue().addData(stream);
            container.setState(128);
            return false;
        }
        int remaining = length - currentLength;
        byte[] data = new byte[remaining];
        stream.get(data, 0, remaining);
        currentTlv.getValue().addData(data);
        container.setState(512);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean treatTLVDoneState(ByteBuffer stream, IAsn1Container container) throws DecoderException {
        if (log.isDebugEnabled()) {
            this.dumpTLVTree(container);
        }
        container.getGrammar().executeAction(container);
        if (!this.isTLVDecoded(container)) {
            container.setState(0);
            return stream.hasRemaining();
        }
        if (container.getState() == -1) {
            container.setState(1024);
            return stream.hasRemaining();
        }
        if (container.isGrammarEndAllowed()) {
            container.setState(1024);
            return stream.hasRemaining();
        }
        log.error("The PDU is decoded, but we should have had more TLVs");
        throw new DecoderException("Truncated PDU. Some elements are lacking, accordingly to the grammar");
    }

    private String stateToString(int state) {
        switch (state) {
            case 0: {
                return "TAG_STATE_START";
            }
            case 1: {
                return "TAG_STATE_PENDING";
            }
            case 2: {
                return "TAG_STATE_END";
            }
            case 4: {
                return "TAG_STATE_OVERFLOW";
            }
            case 8: {
                return "LENGTH_STATE_START";
            }
            case 16: {
                return "LENGTH_STATE_PENDING";
            }
            case 32: {
                return "LENGTH_STATE_END";
            }
            case 64: {
                return "VALUE_STATE_START";
            }
            case 128: {
                return "VALUE_STATE_PENDING";
            }
            case 512: {
                return "TLV_STATE_DONE";
            }
        }
        return "UNKNOWN_STATE";
    }

    public void decode(ByteBuffer stream, IAsn1Container container) throws DecoderException {
        boolean hasRemaining = stream.hasRemaining();
        log.debug(">>>==========================================");
        log.debug("--> Decoding a PDU");
        log.debug(">>>------------------------------------------");
        while (hasRemaining) {
            if (log.isDebugEnabled()) {
                log.debug("--- State = {} ---", (Object)this.stateToString(container.getState()));
                if (stream.hasRemaining()) {
                    byte octet = stream.get(stream.position());
                    log.debug("  current byte : {}", (Object)Asn1StringUtils.dumpByte(octet));
                } else {
                    log.debug("  no more byte to decode in the stream");
                }
            }
            switch (container.getState()) {
                case 0: {
                    container.grammarEndAllowed(false);
                    hasRemaining = this.treatTagStartState(stream, container);
                    break;
                }
                case 1: {
                    hasRemaining = this.treatTagPendingState(stream, container);
                    break;
                }
                case 2: {
                    this.treatTagEndState(container);
                    break;
                }
                case 4: {
                    log.error("Incompatible state : OVERFLOW");
                    throw new DecoderException("Incompatible state occured");
                }
                case 8: {
                    hasRemaining = this.treatLengthStartState(stream, container);
                    break;
                }
                case 16: {
                    hasRemaining = this.treatLengthPendingState(stream, container);
                    break;
                }
                case 32: {
                    this.treatLengthEndState(container);
                    break;
                }
                case 64: {
                    hasRemaining = this.treatValueStartState(stream, container);
                    break;
                }
                case 128: {
                    hasRemaining = this.treatValuePendingState(stream, container);
                    break;
                }
                case 256: {
                    hasRemaining = stream.hasRemaining();
                    break;
                }
                case 512: {
                    hasRemaining = this.treatTLVDoneState(stream, container);
                    break;
                }
                case 1024: {
                    log.warn("The PDU has been fully decoded but there are still bytes in the buffer.");
                    hasRemaining = false;
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("<<<------------------------------------------");
            if (container.getState() == 1024) {
                log.debug("<-- Stop decoding : {}", (Object)container.getCurrentTLV().toString());
            } else {
                log.debug("<-- End decoding : {}", (Object)container.getCurrentTLV().toString());
            }
            log.debug("<<<==========================================");
        }
    }

    public int getMaxLengthLength() {
        return this.maxLengthLength;
    }

    public int getMaxTagLength() {
        return this.maxTagLength;
    }

    public void disallowIndefiniteLength() {
        this.indefiniteLengthAllowed = false;
    }

    public void allowIndefiniteLength() {
        this.indefiniteLengthAllowed = true;
    }

    public boolean isIndefiniteLengthAllowed() {
        return this.indefiniteLengthAllowed;
    }

    public void setMaxLengthLength(int maxLengthLength) throws DecoderException {
        if (this.indefiniteLengthAllowed && maxLengthLength > 126) {
            throw new DecoderException("Length above 126 bytes are not allowed for a definite form Length");
        }
        this.maxLengthLength = maxLengthLength;
    }

    public void setMaxTagLength(int maxTagLength) {
        this.maxTagLength = maxTagLength;
    }
}

