/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.der;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Vector;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.BERConstructedOctetString;
import org.apache.directory.shared.asn1.der.BERNull;
import org.apache.directory.shared.asn1.der.BERSequence;
import org.apache.directory.shared.asn1.der.BERSet;
import org.apache.directory.shared.asn1.der.BERTaggedObject;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DERBMPString;
import org.apache.directory.shared.asn1.der.DERBitString;
import org.apache.directory.shared.asn1.der.DERBoolean;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DEREnumerated;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERGeneralizedTime;
import org.apache.directory.shared.asn1.der.DERIA5String;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERNull;
import org.apache.directory.shared.asn1.der.DERNumericString;
import org.apache.directory.shared.asn1.der.DERObject;
import org.apache.directory.shared.asn1.der.DERObjectIdentifier;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERPrintableString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERSet;
import org.apache.directory.shared.asn1.der.DERTaggedObject;
import org.apache.directory.shared.asn1.der.DERTeletexString;
import org.apache.directory.shared.asn1.der.DERUTCTime;
import org.apache.directory.shared.asn1.der.DERUTF8String;
import org.apache.directory.shared.asn1.der.DERUniversalString;
import org.apache.directory.shared.asn1.der.DERUnknownTag;
import org.apache.directory.shared.asn1.der.DERVisibleString;

public class ASN1InputStream
extends FilterInputStream {
    private boolean EOF_FOUND = false;
    private DERObject END_OF_STREAM = new DERObject(0, null){

        public void encode(ASN1OutputStream out) throws IOException {
            throw new IOException("End of stream.");
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            return o == this;
        }
    };

    public ASN1InputStream(ByteBuffer in) {
        super(ASN1InputStream.newInputStream(in));
    }

    public ASN1InputStream(byte[] input) {
        super(new ByteArrayInputStream(input));
    }

    private static InputStream newInputStream(final ByteBuffer buf) {
        return new InputStream(){

            public synchronized int read() throws IOException {
                if (!buf.hasRemaining()) {
                    return -1;
                }
                int result = buf.get() & 0xFF;
                return result;
            }

            public synchronized int read(byte[] bytes, int off, int len) throws IOException {
                len = Math.min(len, buf.remaining());
                buf.get(bytes, off, len);
                return len;
            }
        };
    }

    protected int readLength() throws IOException {
        int length = this.read();
        if (length < 0) {
            throw new IOException("EOF found when length expected.");
        }
        if (length == 128) {
            return -1;
        }
        if (length > 127) {
            int size = length & 0x7F;
            if (size > 4) {
                throw new IOException("DER length more than 4 bytes.");
            }
            length = 0;
            for (int i = 0; i < size; ++i) {
                int next = this.read();
                if (next < 0) {
                    throw new IOException("EOF found reading length.");
                }
                length = (length << 8) + next;
            }
            if (length < 0) {
                throw new IOException("Corrupted steam - negative length found.");
            }
        }
        return length;
    }

    protected void readFully(byte[] bytes) throws IOException {
        int len;
        int left = bytes.length;
        if (left == 0) {
            return;
        }
        while ((len = this.read(bytes, bytes.length - left, left)) > 0) {
            if ((left -= len) != 0) continue;
            return;
        }
        if (left != 0) {
            throw new EOFException("EOF encountered in middle of object.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DEREncodable buildObject(int tag, byte[] bytes) throws IOException {
        if ((tag & 0x40) != 0) {
            return new DERApplicationSpecific(tag, bytes);
        }
        switch (tag) {
            case 5: {
                return new DERNull();
            }
            case 48: {
                ASN1InputStream ais = new ASN1InputStream(bytes);
                DEREncodable obj = null;
                DERSequence sequence = new DERSequence();
                try {
                    obj = ais.readObject();
                    while (obj != null) {
                        sequence.add(obj);
                        obj = ais.readObject();
                    }
                }
                finally {
                    ais.close();
                }
                return sequence;
            }
            case 49: {
                ASN1InputStream ais = new ASN1InputStream(bytes);
                DERSet set = new DERSet();
                try {
                    DEREncodable obj = ais.readObject();
                    while (obj != null) {
                        set.add(obj);
                        obj = ais.readObject();
                    }
                }
                finally {
                    ais.close();
                }
                return set;
            }
            case 1: {
                return new DERBoolean(bytes);
            }
            case 2: {
                return new DERInteger(bytes);
            }
            case 10: {
                return new DEREnumerated(bytes);
            }
            case 6: {
                return new DERObjectIdentifier(bytes);
            }
            case 3: {
                return new DERBitString(bytes);
            }
            case 18: {
                return new DERNumericString(bytes);
            }
            case 12: {
                return new DERUTF8String(bytes);
            }
            case 19: {
                return new DERPrintableString(bytes);
            }
            case 22: {
                return new DERIA5String(bytes);
            }
            case 20: {
                return new DERTeletexString(bytes);
            }
            case 26: {
                return new DERVisibleString(bytes);
            }
            case 27: {
                return new DERGeneralString(bytes);
            }
            case 28: {
                return new DERUniversalString(bytes);
            }
            case 30: {
                return new DERBMPString(bytes);
            }
            case 4: {
                return new DEROctetString(bytes);
            }
            case 23: {
                return new DERUTCTime(bytes);
            }
            case 24: {
                return new DERGeneralizedTime(bytes);
            }
        }
        if ((tag & 0x80) != 0) {
            Object tmp;
            int tagNo = tag & 0x1F;
            if (tagNo == 31) {
                int idx = 0;
                tagNo = 0;
                while ((bytes[idx] & 0x80) != 0) {
                    tagNo |= bytes[idx++] & 0x7F;
                    tagNo <<= 7;
                }
                tagNo |= bytes[idx] & 0x7F;
                tmp = bytes;
                bytes = new byte[((byte[])tmp).length - (idx + 1)];
                System.arraycopy(tmp, idx + 1, bytes, 0, bytes.length);
            }
            if (bytes.length == 0) {
                if ((tag & 0x20) == 0) {
                    return new DERTaggedObject(tagNo, new DERNull());
                }
                return new DERTaggedObject(false, tagNo, new DERSequence());
            }
            if ((tag & 0x20) == 0) {
                return new DERTaggedObject(false, tagNo, new DEROctetString(bytes));
            }
            ASN1InputStream ais = new ASN1InputStream(bytes);
            try {
                DEREncodable encodable = ais.readObject();
                if (ais.available() == 0) {
                    tmp = new DERTaggedObject(true, tagNo, encodable, bytes);
                    return tmp;
                }
                DERSequence derSequence = new DERSequence();
                while (encodable != null) {
                    derSequence.add(encodable);
                    encodable = ais.readObject();
                }
                DERTaggedObject dERTaggedObject = new DERTaggedObject(false, tagNo, derSequence);
                return dERTaggedObject;
            }
            finally {
                ais.close();
            }
        }
        return new DERUnknownTag(tag, bytes);
    }

    private byte[] readIndefiniteLengthFully() throws IOException {
        int b;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int b1 = this.read();
        while ((b = this.read()) >= 0 && (b1 != 0 || b != 0)) {
            baos.write(b1);
            b1 = b;
        }
        return baos.toByteArray();
    }

    private BERConstructedOctetString buildConstructedOctetString() throws IOException {
        DEREncodable encodable;
        Vector<DEREncodable> octets = new Vector<DEREncodable>();
        while ((encodable = this.readObject()) != this.END_OF_STREAM) {
            octets.addElement(encodable);
        }
        return new BERConstructedOctetString(octets);
    }

    public DEREncodable readObject() throws IOException {
        int tag = this.read();
        if (tag == -1) {
            if (this.EOF_FOUND) {
                throw new EOFException("Attempt to read past end of file.");
            }
            this.EOF_FOUND = true;
            return null;
        }
        int length = this.readLength();
        if (length < 0) {
            switch (tag) {
                case 5: {
                    return new BERNull();
                }
                case 48: {
                    DEREncodable obj;
                    BERSequence sequence = new BERSequence();
                    while ((obj = this.readObject()) != this.END_OF_STREAM) {
                        sequence.add(obj);
                    }
                    return sequence;
                }
                case 49: {
                    DEREncodable obj;
                    BERSet set = new BERSet();
                    while ((obj = this.readObject()) != this.END_OF_STREAM) {
                        set.add(obj);
                    }
                    return set;
                }
                case 36: {
                    return this.buildConstructedOctetString();
                }
            }
            if ((tag & 0x80) != 0) {
                int tagNo = tag & 0x1F;
                if (tagNo == 31) {
                    int b = this.read();
                    tagNo = 0;
                    while (b >= 0 && (b & 0x80) != 0) {
                        tagNo |= b & 0x7F;
                        tagNo <<= 7;
                        b = this.read();
                    }
                    tagNo |= b & 0x7F;
                }
                if ((tag & 0x20) == 0) {
                    byte[] bytes = this.readIndefiniteLengthFully();
                    return new BERTaggedObject(false, tagNo, new DEROctetString(bytes));
                }
                DEREncodable dObj = this.readObject();
                if (dObj == this.END_OF_STREAM) {
                    return new DERTaggedObject(tagNo);
                }
                DEREncodable next = this.readObject();
                if (next == this.END_OF_STREAM) {
                    return new BERTaggedObject(tagNo, dObj);
                }
                BERSequence berSequence = new BERSequence();
                berSequence.add(dObj);
                do {
                    berSequence.add(next);
                } while ((next = this.readObject()) != this.END_OF_STREAM);
                return new BERTaggedObject(false, tagNo, berSequence);
            }
            throw new IOException("Unknown BER object encountered.");
        }
        if (tag == 0 && length == 0) {
            return this.END_OF_STREAM;
        }
        byte[] bytes = new byte[length];
        this.readFully(bytes);
        return this.buildObject(tag, bytes);
    }
}

