/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended.ads_impl.cancel;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.extras.extended.CancelRequest;
import org.apache.directory.shared.ldap.extras.extended.CancelResponse;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.cancel.Cancel;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.cancel.CancelDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CancelRequestDecorator
extends ExtendedRequestDecorator<CancelRequest, CancelResponse>
implements CancelRequest {
    private static final Logger LOG = LoggerFactory.getLogger(CancelRequestDecorator.class);

    public CancelRequestDecorator(LdapApiService codec, CancelRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    @Override
    public int getCancelId() {
        return ((CancelRequest)this.getDecorated()).getCancelId();
    }

    @Override
    public void setCancelId(int cancelId) {
        if (cancelId == this.getCancelId()) {
            return;
        }
        this.requestValue = null;
        ((CancelRequest)this.getDecorated()).setCancelId(cancelId);
    }

    @Override
    public byte[] getRequestValue() {
        if (this.requestValue == null) {
            try {
                Cancel cancel = new Cancel();
                cancel.setCancelId(((CancelRequest)this.getDecorated()).getCancelId());
                this.requestValue = cancel.encode().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err(I18n.ERR_04164, new Object[0]), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.requestValue;
    }

    @Override
    public void setRequestValue(byte[] requestValue) {
        CancelDecoder decoder = new CancelDecoder();
        try {
            Cancel cancel = (Cancel)decoder.decode(requestValue);
            if (requestValue != null) {
                this.requestValue = new byte[requestValue.length];
                System.arraycopy(requestValue, 0, this.requestValue, 0, requestValue.length);
            } else {
                this.requestValue = null;
            }
            ((CancelRequest)this.getDecorated()).setCancelId(cancel.getCancelId());
        }
        catch (DecoderException e) {
            LOG.error(I18n.err(I18n.ERR_04165, new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

