/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.controls.syncrepl_impl;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.Grammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.tlv.BerValue;
import org.apache.directory.shared.asn1.ber.tlv.BooleanDecoder;
import org.apache.directory.shared.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.extras.controls.SyncInfoValue;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncInfoValueContainer;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncInfoValueStatesEnum;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncInfoValueTags;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SyncInfoValueGrammar
extends AbstractGrammar {
    static final Logger LOG = LoggerFactory.getLogger(SyncInfoValueGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar instance = new SyncInfoValueGrammar();

    private SyncInfoValueGrammar() {
        this.setName(SyncInfoValueGrammar.class.getName());
        this.transitions = new GrammarTransition[SyncInfoValueStatesEnum.LAST_SYNC_INFO_VALUE_STATE.ordinal()][256];
        this.transitions[SyncInfoValueStatesEnum.START_STATE.ordinal()][SyncInfoValueTags.NEW_COOKIE_TAG.getValue()] = new GrammarTransition<SyncInfoValueContainer>(SyncInfoValueStatesEnum.START_STATE, SyncInfoValueStatesEnum.NEW_COOKIE_STATE, SyncInfoValueTags.NEW_COOKIE_TAG.getValue(), new GrammarAction<SyncInfoValueContainer>("NewCookie choice for SyncInfoValueControl"){

            @Override
            public void action(SyncInfoValueContainer container) {
                SyncInfoValue control = container.getSyncInfoValueControl();
                BerValue value = container.getCurrentTLV().getValue();
                byte[] newCookie = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("newcookie = " + Strings.dumpBytes(newCookie));
                }
                control.setCookie(newCookie);
                container.setGrammarEndAllowed(true);
                container.setSyncInfoValueControl(control);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.START_STATE.ordinal()][SyncInfoValueTags.REFRESH_DELETE_TAG.getValue()] = new GrammarTransition<SyncInfoValueContainer>(SyncInfoValueStatesEnum.START_STATE, SyncInfoValueStatesEnum.REFRESH_DELETE_STATE, SyncInfoValueTags.REFRESH_DELETE_TAG.getValue(), new GrammarAction<SyncInfoValueContainer>("RefreshDelete choice for SyncInfoValueControl"){

            @Override
            public void action(SyncInfoValueContainer container) {
                SyncInfoValue control = container.getSyncInfoValueControl();
                container.setSyncInfoValueControl(control);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.REFRESH_DELETE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<SyncInfoValueContainer>(SyncInfoValueStatesEnum.REFRESH_DELETE_STATE, SyncInfoValueStatesEnum.REFRESH_DELETE_COOKIE_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<SyncInfoValueContainer>("RefreshDelete cookie"){

            @Override
            public void action(SyncInfoValueContainer container) {
                SyncInfoValue control = container.getSyncInfoValueControl();
                BerValue value = container.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("cookie = " + Strings.dumpBytes(cookie));
                }
                container.getSyncInfoValueControl().setCookie(cookie);
                container.setSyncInfoValueControl(control);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.REFRESH_DELETE_COOKIE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition<SyncInfoValueContainer>(SyncInfoValueStatesEnum.REFRESH_DELETE_COOKIE_STATE, SyncInfoValueStatesEnum.LAST_SYNC_INFO_VALUE_STATE, UniversalTag.BOOLEAN.getValue(), new GrammarAction<SyncInfoValueContainer>("RefreshDelete refreshDone flag"){

            @Override
            public void action(SyncInfoValueContainer container) throws DecoderException {
                SyncInfoValue control = container.getSyncInfoValueControl();
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean refreshDone = BooleanDecoder.parse(value);
                    if (IS_DEBUG) {
                        LOG.debug("refreshDone = {}", (Object)refreshDone);
                    }
                    control.setRefreshDone(refreshDone);
                    container.setSyncInfoValueControl(control);
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException be) {
                    String msg = I18n.err(I18n.ERR_04025, new Object[0]);
                    LOG.error(msg, (Throwable)be);
                    throw new DecoderException(msg);
                }
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.REFRESH_DELETE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition<SyncInfoValueContainer>(SyncInfoValueStatesEnum.REFRESH_DELETE_STATE, SyncInfoValueStatesEnum.LAST_SYNC_INFO_VALUE_STATE, UniversalTag.BOOLEAN.getValue(), new GrammarAction<SyncInfoValueContainer>("RefreshDelete refreshDone flag"){

            @Override
            public void action(SyncInfoValueContainer container) throws DecoderException {
                SyncInfoValue control = container.getSyncInfoValueControl();
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean refreshDone = BooleanDecoder.parse(value);
                    if (IS_DEBUG) {
                        LOG.debug("refreshDone = {}", (Object)refreshDone);
                    }
                    control.setRefreshDone(refreshDone);
                    container.setSyncInfoValueControl(control);
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException be) {
                    String msg = I18n.err(I18n.ERR_04025, new Object[0]);
                    LOG.error(msg, (Throwable)be);
                    throw new DecoderException(msg);
                }
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.START_STATE.ordinal()][SyncInfoValueTags.REFRESH_PRESENT_TAG.getValue()] = new GrammarTransition<SyncInfoValueContainer>(SyncInfoValueStatesEnum.START_STATE, SyncInfoValueStatesEnum.REFRESH_PRESENT_STATE, SyncInfoValueTags.REFRESH_PRESENT_TAG.getValue(), new GrammarAction<SyncInfoValueContainer>("RefreshDelete choice for SyncInfoValueControl"){

            @Override
            public void action(SyncInfoValueContainer container) {
                SyncInfoValue control = container.getSyncInfoValueControl();
                container.setSyncInfoValueControl(control);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.REFRESH_PRESENT_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<SyncInfoValueContainer>(SyncInfoValueStatesEnum.REFRESH_PRESENT_STATE, SyncInfoValueStatesEnum.REFRESH_PRESENT_COOKIE_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<SyncInfoValueContainer>("RefreshPresent cookie"){

            @Override
            public void action(SyncInfoValueContainer container) {
                SyncInfoValue control = container.getSyncInfoValueControl();
                BerValue value = container.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("cookie = " + Strings.dumpBytes(cookie));
                }
                container.getSyncInfoValueControl().setCookie(cookie);
                container.setSyncInfoValueControl(control);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.REFRESH_PRESENT_COOKIE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition<SyncInfoValueContainer>(SyncInfoValueStatesEnum.REFRESH_PRESENT_COOKIE_STATE, SyncInfoValueStatesEnum.LAST_SYNC_INFO_VALUE_STATE, UniversalTag.BOOLEAN.getValue(), new GrammarAction<SyncInfoValueContainer>("RefreshPresent refreshDone flag"){

            @Override
            public void action(SyncInfoValueContainer container) throws DecoderException {
                SyncInfoValue control = container.getSyncInfoValueControl();
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean refreshDone = BooleanDecoder.parse(value);
                    if (IS_DEBUG) {
                        LOG.debug("refreshDone = {}", (Object)refreshDone);
                    }
                    control.setRefreshDone(refreshDone);
                    container.setSyncInfoValueControl(control);
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException be) {
                    String msg = I18n.err(I18n.ERR_04025, new Object[0]);
                    LOG.error(msg, (Throwable)be);
                    throw new DecoderException(msg);
                }
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.REFRESH_PRESENT_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition<SyncInfoValueContainer>(SyncInfoValueStatesEnum.REFRESH_PRESENT_STATE, SyncInfoValueStatesEnum.LAST_SYNC_INFO_VALUE_STATE, UniversalTag.BOOLEAN.getValue(), new GrammarAction<SyncInfoValueContainer>("RefreshPresent refreshDone flag"){

            @Override
            public void action(SyncInfoValueContainer container) throws DecoderException {
                SyncInfoValue control = container.getSyncInfoValueControl();
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean refreshDone = BooleanDecoder.parse(value);
                    if (IS_DEBUG) {
                        LOG.debug("refreshDone = {}", (Object)refreshDone);
                    }
                    control.setRefreshDone(refreshDone);
                    container.setSyncInfoValueControl(control);
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException be) {
                    String msg = I18n.err(I18n.ERR_04025, new Object[0]);
                    LOG.error(msg, (Throwable)be);
                    throw new DecoderException(msg);
                }
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.START_STATE.ordinal()][SyncInfoValueTags.SYNC_ID_SET_TAG.getValue()] = new GrammarTransition<SyncInfoValueContainer>(SyncInfoValueStatesEnum.START_STATE, SyncInfoValueStatesEnum.SYNC_ID_SET_STATE, SyncInfoValueTags.SYNC_ID_SET_TAG.getValue(), new GrammarAction<SyncInfoValueContainer>("SyncIdSet choice for SyncInfoValueControl"){

            @Override
            public void action(SyncInfoValueContainer container) {
                SyncInfoValue control = container.getSyncInfoValueControl();
                container.setSyncInfoValueControl(control);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.SYNC_ID_SET_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<SyncInfoValueContainer>(SyncInfoValueStatesEnum.SYNC_ID_SET_STATE, SyncInfoValueStatesEnum.SYNC_ID_SET_COOKIE_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<SyncInfoValueContainer>("SyncIdSet cookie"){

            @Override
            public void action(SyncInfoValueContainer container) {
                SyncInfoValue control = container.getSyncInfoValueControl();
                BerValue value = container.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("cookie = " + Strings.dumpBytes(cookie));
                }
                container.getSyncInfoValueControl().setCookie(cookie);
                container.setSyncInfoValueControl(control);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.SYNC_ID_SET_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition<SyncInfoValueContainer>(SyncInfoValueStatesEnum.SYNC_ID_SET_STATE, SyncInfoValueStatesEnum.SYNC_ID_SET_REFRESH_DELETES_STATE, UniversalTag.BOOLEAN.getValue(), new GrammarAction<SyncInfoValueContainer>("SyncIdSet refreshDeletes"){

            @Override
            public void action(SyncInfoValueContainer container) throws DecoderException {
                SyncInfoValue control = container.getSyncInfoValueControl();
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean refreshDeletes = BooleanDecoder.parse(value);
                    if (IS_DEBUG) {
                        LOG.debug("refreshDeletes = {}", (Object)refreshDeletes);
                    }
                    control.setRefreshDeletes(refreshDeletes);
                    container.setSyncInfoValueControl(control);
                }
                catch (BooleanDecoderException be) {
                    String msg = I18n.err(I18n.ERR_04026, new Object[0]);
                    LOG.error(msg, (Throwable)be);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[SyncInfoValueStatesEnum.SYNC_ID_SET_COOKIE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition<SyncInfoValueContainer>(SyncInfoValueStatesEnum.SYNC_ID_SET_COOKIE_STATE, SyncInfoValueStatesEnum.SYNC_ID_SET_REFRESH_DELETES_STATE, UniversalTag.BOOLEAN.getValue(), new GrammarAction<SyncInfoValueContainer>("SyncIdSet refreshDeletes"){

            @Override
            public void action(SyncInfoValueContainer container) throws DecoderException {
                SyncInfoValue control = container.getSyncInfoValueControl();
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean refreshDeletes = BooleanDecoder.parse(value);
                    if (IS_DEBUG) {
                        LOG.debug("refreshDeletes = {}", (Object)refreshDeletes);
                    }
                    control.setRefreshDeletes(refreshDeletes);
                    container.setSyncInfoValueControl(control);
                }
                catch (BooleanDecoderException be) {
                    String msg = I18n.err(I18n.ERR_04024, new Object[0]);
                    LOG.error(msg, (Throwable)be);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[SyncInfoValueStatesEnum.SYNC_ID_SET_STATE.ordinal()][UniversalTag.SET.getValue()] = new GrammarTransition<SyncInfoValueContainer>(SyncInfoValueStatesEnum.SYNC_ID_SET_STATE, SyncInfoValueStatesEnum.SYNC_ID_SET_SET_OF_UUIDS_STATE, UniversalTag.SET.getValue(), new GrammarAction<SyncInfoValueContainer>("SyncIdSet syncUUIDs"){

            @Override
            public void action(SyncInfoValueContainer container) throws DecoderException {
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.SYNC_ID_SET_COOKIE_STATE.ordinal()][UniversalTag.SET.getValue()] = new GrammarTransition<SyncInfoValueContainer>(SyncInfoValueStatesEnum.SYNC_ID_SET_COOKIE_STATE, SyncInfoValueStatesEnum.SYNC_ID_SET_SET_OF_UUIDS_STATE, UniversalTag.SET.getValue(), new GrammarAction<SyncInfoValueContainer>("SyncIdSet syncUUIDs"){

            @Override
            public void action(SyncInfoValueContainer container) throws DecoderException {
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.SYNC_ID_SET_REFRESH_DELETES_STATE.ordinal()][UniversalTag.SET.getValue()] = new GrammarTransition<SyncInfoValueContainer>(SyncInfoValueStatesEnum.SYNC_ID_SET_REFRESH_DELETES_STATE, SyncInfoValueStatesEnum.SYNC_ID_SET_SET_OF_UUIDS_STATE, UniversalTag.SET.getValue(), new GrammarAction<SyncInfoValueContainer>("SyncIdSet syncUUIDs"){

            @Override
            public void action(SyncInfoValueContainer container) throws DecoderException {
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.SYNC_ID_SET_SET_OF_UUIDS_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<SyncInfoValueContainer>(SyncInfoValueStatesEnum.SYNC_ID_SET_SET_OF_UUIDS_STATE, SyncInfoValueStatesEnum.SYNC_ID_SET_UUID_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<SyncInfoValueContainer>("SyncIdSet first UUID"){

            @Override
            public void action(SyncInfoValueContainer container) throws DecoderException {
                SyncInfoValue control = container.getSyncInfoValueControl();
                BerValue value = container.getCurrentTLV().getValue();
                byte[] uuid = value.getData();
                if (uuid == null || uuid.length != 16) {
                    String msg = I18n.err(I18n.ERR_04027, new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                if (IS_DEBUG) {
                    LOG.debug("UUID = " + Strings.dumpBytes(uuid));
                }
                control.addSyncUUID(uuid);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.SYNC_ID_SET_UUID_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<SyncInfoValueContainer>(SyncInfoValueStatesEnum.SYNC_ID_SET_UUID_STATE, SyncInfoValueStatesEnum.SYNC_ID_SET_UUID_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<SyncInfoValueContainer>("SyncIdSet UUID"){

            @Override
            public void action(SyncInfoValueContainer container) throws DecoderException {
                SyncInfoValue control = container.getSyncInfoValueControl();
                BerValue value = container.getCurrentTLV().getValue();
                byte[] uuid = value.getData();
                if (uuid == null || uuid.length != 16) {
                    String msg = I18n.err(I18n.ERR_04027, new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                if (IS_DEBUG) {
                    LOG.debug("UUID = " + Strings.dumpBytes(uuid));
                }
                control.getSyncUUIDs().add(uuid);
                container.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar getInstance() {
        return instance;
    }
}

