/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.request;

import org.apache.directory.shared.dsmlv2.request.AbstractResultResponseRequestDsml;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.model.exception.MessageException;
import org.apache.directory.shared.ldap.model.message.BindRequest;
import org.apache.directory.shared.ldap.model.message.BindRequestImpl;
import org.apache.directory.shared.ldap.model.message.BindResponse;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindRequestDsml
extends AbstractResultResponseRequestDsml<BindRequest, BindResponse>
implements BindRequest {
    public BindRequestDsml(LdapApiService codec) {
        super(codec, new BindRequestImpl());
    }

    public BindRequestDsml(LdapApiService codec, BindRequest ldapMessage) {
        super(codec, ldapMessage);
    }

    @Override
    public MessageTypeEnum getType() {
        return ((BindRequest)this.getDecorated()).getType();
    }

    @Override
    public Element toDsml(Element root) {
        Element element = super.toDsml(root);
        BindRequest request = (BindRequest)this.getDecorated();
        Dn dn = request.getDn();
        if (!Dn.isNullOrEmpty(dn)) {
            element.addAttribute("principal", dn.getName());
        } else {
            String name = request.getName();
            element.addAttribute("principal", name);
        }
        return element;
    }

    @Override
    public MessageTypeEnum getResponseType() {
        return ((BindRequest)this.getDecorated()).getResponseType();
    }

    @Override
    public boolean isSimple() {
        return ((BindRequest)this.getDecorated()).isSimple();
    }

    @Override
    public boolean getSimple() {
        return ((BindRequest)this.getDecorated()).getSimple();
    }

    @Override
    public BindRequest setSimple(boolean isSimple) {
        ((BindRequest)this.getDecorated()).setSimple(isSimple);
        return this;
    }

    @Override
    public byte[] getCredentials() {
        return ((BindRequest)this.getDecorated()).getCredentials();
    }

    @Override
    public BindRequest setCredentials(String credentials) {
        ((BindRequest)this.getDecorated()).setCredentials(credentials);
        return this;
    }

    @Override
    public BindRequest setCredentials(byte[] credentials) {
        ((BindRequest)this.getDecorated()).setCredentials(credentials);
        return this;
    }

    @Override
    public String getName() {
        return ((BindRequest)this.getDecorated()).getName();
    }

    @Override
    public BindRequest setName(String name) {
        ((BindRequest)this.getDecorated()).setName(name);
        return this;
    }

    @Override
    public Dn getDn() {
        return ((BindRequest)this.getDecorated()).getDn();
    }

    @Override
    public BindRequest setDn(Dn dn) {
        ((BindRequest)this.getDecorated()).setDn(dn);
        return this;
    }

    @Override
    public boolean isVersion3() {
        return ((BindRequest)this.getDecorated()).isVersion3();
    }

    @Override
    public boolean getVersion3() {
        return ((BindRequest)this.getDecorated()).getVersion3();
    }

    @Override
    public BindRequest setVersion3(boolean isVersion3) {
        ((BindRequest)this.getDecorated()).setVersion3(isVersion3);
        return this;
    }

    @Override
    public String getSaslMechanism() {
        return ((BindRequest)this.getDecorated()).getSaslMechanism();
    }

    @Override
    public BindRequest setSaslMechanism(String saslMechanism) {
        ((BindRequest)this.getDecorated()).setSaslMechanism(saslMechanism);
        return this;
    }

    @Override
    public BindRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public BindRequest addControl(Control control) throws MessageException {
        return (BindRequest)super.addControl(control);
    }

    @Override
    public BindRequest addAllControls(Control[] controls) throws MessageException {
        return (BindRequest)super.addAllControls(controls);
    }

    @Override
    public BindRequest removeControl(Control control) throws MessageException {
        return (BindRequest)super.removeControl(control);
    }
}

