/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.wrapper;

import org.apache.directory.api.util.Strings;
import org.apache.directory.server.ApacheDsService;
import org.apache.directory.server.core.api.InstanceLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;

public final class ApacheDsTanukiWrapper
implements WrapperListener {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheDsTanukiWrapper.class);
    private ApacheDsService service;

    private ApacheDsTanukiWrapper() {
    }

    public static void main(String[] args) {
        WrapperManager.start((WrapperListener)new ApacheDsTanukiWrapper(), (String[])args);
    }

    public void repair(String instanceDirectory) {
        System.out.println("Trying to repair the following data :" + instanceDirectory);
        InstanceLayout layout = new InstanceLayout(instanceDirectory);
        this.service = new ApacheDsService();
        try {
            System.out.println("Starting the service.");
            this.service.start(layout, true);
            System.out.println("Service started.");
        }
        catch (Exception e) {
            LOG.error("Failed to start the service.", (Throwable)e);
            this.stop(1);
            System.exit(5);
        }
        try {
            System.out.println("Repairing the database.");
            this.service.repair(layout);
            System.out.println("Database repaired.");
        }
        catch (Exception e) {
            LOG.error("Failed to repair the database.", (Throwable)e);
            this.stop(1);
            System.exit(5);
        }
        this.stop(0);
    }

    public Integer start(String[] args) {
        LOG.info("Starting the service...");
        if (args != null) {
            int argNb = 0;
            for (String arg : args) {
                LOG.info("Args[{}] : {}", (Object)argNb, (Object)arg);
                ++argNb;
            }
        }
        if (args != null) {
            String action = "START";
            String instanceDirectory = args[0];
            block1 : switch (args.length) {
                case 2: {
                    action = args[1];
                }
                case 1: {
                    this.service = new ApacheDsService();
                    InstanceLayout instanceLayout = new InstanceLayout(instanceDirectory);
                    switch (Strings.toLowerCaseAscii((String)action)) {
                        case "stop": {
                            LOG.debug("Stopping runtime");
                            this.stop(1);
                            break block1;
                        }
                        case "repair": {
                            LOG.debug("Fixing the database runtime");
                            this.repair(instanceDirectory);
                            break block1;
                        }
                    }
                    LOG.debug("Starting runtime");
                    try {
                        this.service.start(instanceLayout);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to start the service.", (Throwable)e);
                        System.exit(5);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Program must be launched with at least 1 argument, the path to the instance directory.");
                }
            }
        }
        return null;
    }

    public int stop(int exitCode) {
        LOG.info("Attempting graceful shutdown of the service...");
        try {
            this.service.stop();
        }
        catch (Exception e) {
            LOG.error("Failed to stop the service.", (Throwable)e);
            System.exit(6);
        }
        LOG.info("Completed graceful shutdown of the service...");
        return exitCode;
    }

    public void controlEvent(int event) {
        if (!(WrapperManager.isControlledByNativeWrapper() || event != 200 && event != 201 && event != 203)) {
            WrapperManager.stop((int)0);
        }
    }
}

