/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.utils;

import java.util.Comparator;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxChecker;
import org.apache.directory.shared.ldap.util.DateUtils;

public class AttributesFactory {
    public Attributes getAttributes(SchemaObject obj, Schema schema) throws NamingException {
        if (obj instanceof Syntax) {
            return this.getAttributes((Syntax)obj, schema);
        }
        if (obj instanceof MatchingRule) {
            return this.getAttributes((MatchingRule)obj, schema);
        }
        if (obj instanceof AttributeType) {
            return this.getAttributes((AttributeType)obj, schema);
        }
        if (obj instanceof ObjectClass) {
            return this.getAttributes((ObjectClass)obj, schema);
        }
        if (obj instanceof MatchingRuleUse) {
            return this.getAttributes((MatchingRuleUse)obj, schema);
        }
        if (obj instanceof DITStructureRule) {
            return this.getAttributes((DITStructureRule)obj, schema);
        }
        if (obj instanceof DITContentRule) {
            return this.getAttributes((DITContentRule)obj, schema);
        }
        if (obj instanceof NameForm) {
            return this.getAttributes((NameForm)obj, schema);
        }
        throw new IllegalArgumentException("Unknown SchemaObject type: " + obj.getClass());
    }

    public Attributes getAttributes(Schema schema) {
        String[] dependencies;
        AttributesImpl entry = new AttributesImpl("objectClass", (Object)"top", true);
        entry.get("objectClass").add("metaSchema");
        entry.put("cn", schema.getSchemaName());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        if (schema.isDisabled()) {
            entry.put("m-disabled", "TRUE");
        }
        if ((dependencies = schema.getDependencies()) != null && dependencies.length > 0) {
            AttributeImpl attr = new AttributeImpl("m-dependencies");
            for (int ii = 0; ii < dependencies.length; ++ii) {
                attr.add(dependencies[ii]);
            }
            entry.put((Attribute)attr);
        }
        return entry;
    }

    public Attributes getAttributes(SyntaxChecker syntaxChecker, Schema schema) {
        AttributesImpl entry = new AttributesImpl("objectClass", (Object)"top", true);
        entry.get("objectClass").add("metaSyntaxChecker");
        entry.put("m-oid", syntaxChecker.getSyntaxOid());
        entry.put("m-fqcn", syntaxChecker.getClass().getName());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Attributes getAttributes(Syntax syntax, Schema schema) {
        AttributesImpl entry = new AttributesImpl("objectClass", (Object)"top", true);
        entry.get("objectClass").add("metaSyntax");
        entry.put("x-humanReadible", this.getBoolean(syntax.isHumanReadible()));
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        this.injectCommon((SchemaObject)syntax, (Attributes)entry);
        return entry;
    }

    public Attributes getAttributes(String oid, Normalizer normalizer, Schema schema) {
        AttributesImpl entry = new AttributesImpl("objectClass", (Object)"top", true);
        entry.get("objectClass").add("metaNormalizer");
        entry.put("m-oid", oid);
        entry.put("m-fqcn", normalizer.getClass().getName());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Attributes getAttributes(String oid, Comparator comparator, Schema schema) {
        AttributesImpl entry = new AttributesImpl("objectClass", (Object)"top", true);
        entry.get("objectClass").add("metaComparator");
        entry.put("m-oid", oid);
        entry.put("m-fqcn", comparator.getClass().getName());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Attributes getAttributes(MatchingRule matchingRule, Schema schema) throws NamingException {
        AttributesImpl entry = new AttributesImpl("objectClass", (Object)"top", true);
        entry.get("objectClass").add("metaMatchingRule");
        entry.put("m-syntax", matchingRule.getSyntax().getOid());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        this.injectCommon((SchemaObject)matchingRule, (Attributes)entry);
        return entry;
    }

    public Attributes getAttributes(MatchingRuleUse matchingRuleUse, Schema schema) {
        AttributesImpl entry = new AttributesImpl("objectClass", (Object)"top", true);
        entry.get("objectClass").add("");
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Attributes getAttributes(DITStructureRule dITStructureRule, Schema schema) {
        AttributesImpl entry = new AttributesImpl("objectClass", (Object)"top", true);
        entry.get("objectClass").add("");
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Attributes getAttributes(DITContentRule dITContentRule, Schema schema) {
        AttributesImpl entry = new AttributesImpl("objectClass", (Object)"top", true);
        entry.get("objectClass").add("");
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Attributes getAttributes(NameForm nameForm, Schema schema) {
        AttributesImpl entry = new AttributesImpl("objectClass", (Object)"top", true);
        entry.get("objectClass").add("");
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Attributes getAttributes(AttributeType attributeType, Schema schema) throws NamingException {
        AttributesImpl entry = new AttributesImpl("objectClass", (Object)"top", true);
        entry.get("objectClass").add("metaAttributeType");
        entry.put("m-syntax", attributeType.getSyntax().getOid());
        entry.put("m-collective", this.getBoolean(attributeType.isCollective()));
        entry.put("m-noUserModification", this.getBoolean(!attributeType.isCanUserModify()));
        entry.put("m-singleValue", this.getBoolean(attributeType.isSingleValue()));
        entry.put("m-usage", attributeType.getUsage().toString());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        this.injectCommon((SchemaObject)attributeType, (Attributes)entry);
        AttributeType superior = attributeType.getSuperior();
        if (superior != null) {
            String sup = superior.getName();
            if (sup == null) {
                sup = superior.getOid();
            }
            entry.put("m-supAttributeType", sup);
        }
        if (attributeType.getEquality() != null) {
            String equality = attributeType.getEquality().getName();
            if (equality == null) {
                equality = attributeType.getEquality().getOid();
            }
            entry.put("m-equality", equality);
        }
        if (attributeType.getSubstr() != null) {
            String substr = attributeType.getSubstr().getName();
            if (substr == null) {
                substr = attributeType.getSubstr().getOid();
            }
            entry.put("m-substr", substr);
        }
        if (attributeType.getOrdering() != null) {
            String ordering = attributeType.getOrdering().getName();
            if (ordering == null) {
                ordering = attributeType.getOrdering().getOid();
            }
            entry.put("m-ordering", ordering);
        }
        return entry;
    }

    public Attributes getAttributes(ObjectClass objectClass, Schema schema) throws NamingException {
        int ii;
        AttributeImpl attr;
        AttributesImpl entry = new AttributesImpl("objectClass", (Object)"top", true);
        entry.get("objectClass").add("metaObjectClass");
        entry.put("m-typeObjectClass", objectClass.getType().toString());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        this.injectCommon((SchemaObject)objectClass, (Attributes)entry);
        if (objectClass.getSuperClasses() != null && objectClass.getSuperClasses().length != 0) {
            attr = new AttributeImpl("m-supObjectClass");
            ObjectClass[] superclasses = objectClass.getSuperClasses();
            for (ii = 0; ii < superclasses.length; ++ii) {
                attr.add(this.getNameOrNumericoid((SchemaObject)superclasses[ii]));
            }
            entry.put((Attribute)attr);
        }
        if (objectClass.getMustList() != null && objectClass.getMustList().length != 0) {
            attr = new AttributeImpl("m-must");
            AttributeType[] mustList = objectClass.getMustList();
            for (ii = 0; ii < mustList.length; ++ii) {
                attr.add(this.getNameOrNumericoid((SchemaObject)mustList[ii]));
            }
            entry.put((Attribute)attr);
        }
        if (objectClass.getMayList() != null && objectClass.getMayList().length != 0) {
            attr = new AttributeImpl("m-may");
            AttributeType[] mayList = objectClass.getMayList();
            for (ii = 0; ii < mayList.length; ++ii) {
                attr.add(this.getNameOrNumericoid((SchemaObject)mayList[ii]));
            }
            entry.put((Attribute)attr);
        }
        return entry;
    }

    private final String getNameOrNumericoid(SchemaObject object) {
        if (object.getName() != null) {
            return object.getName();
        }
        return object.getOid();
    }

    private final void injectCommon(SchemaObject object, Attributes entry) {
        this.injectNames(object.getNames(), entry);
        entry.put("m-obsolete", this.getBoolean(object.isObsolete()));
        entry.put("m-oid", object.getOid());
        if (object.getDescription() != null) {
            entry.put("m-description", object.getDescription());
        }
    }

    private final void injectNames(String[] names, Attributes entry) {
        if (names == null || names.length == 0) {
            return;
        }
        AttributeImpl attr = new AttributeImpl("m-name");
        for (int ii = 0; ii < names.length; ++ii) {
            attr.add(names[ii]);
        }
        entry.put((Attribute)attr);
    }

    private final String getBoolean(boolean value) {
        if (value) {
            return "TRUE";
        }
        return "FALSE";
    }
}

