/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.config.listener;

import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.config.ConfigPartitionReader;
import org.apache.directory.server.config.beans.PasswordPolicyBean;
import org.apache.directory.server.config.builder.ServiceBuilder;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.authn.ppolicy.PasswordPolicyConfiguration;
import org.apache.directory.server.core.api.event.DirectoryListenerAdapter;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.authn.ppolicy.PpolicyConfigContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigChangeListener
extends DirectoryListenerAdapter {
    private ConfigPartitionReader cpReader;
    private DirectoryService directoryService;
    private PpolicyConfigContainer ppolicyConfigContainer;
    private Dn ppolicyConfigDnRoot;
    private static final String PPOLICY_OC_NAME = "ads-passwordPolicy";
    private Attribute passwordPolicyObjectClassAttribute;
    private static final Logger LOG = LoggerFactory.getLogger(ConfigChangeListener.class);

    public ConfigChangeListener(ConfigPartitionReader cpReader, DirectoryService directoryService) throws LdapException {
        this.cpReader = cpReader;
        this.directoryService = directoryService;
        SchemaManager schemaManager = directoryService.getSchemaManager();
        this.ppolicyConfigDnRoot = new Dn(schemaManager, new String[]{"ou=passwordPolicies,ads-interceptorId=authenticationInterceptor,ou=interceptors,ads-directoryServiceId=default,ou=config"});
        AuthenticationInterceptor authInterceptor = (AuthenticationInterceptor)directoryService.getInterceptor(InterceptorEnum.AUTHENTICATION_INTERCEPTOR.getName());
        this.ppolicyConfigContainer = authInterceptor.getPwdPolicyContainer();
        AttributeType ocType = directoryService.getAtProvider().getObjectClass();
        this.passwordPolicyObjectClassAttribute = new DefaultAttribute(ocType, new String[]{PPOLICY_OC_NAME});
    }

    public void entryAdded(AddOperationContext addContext) {
        Entry entry = addContext.getEntry();
        this.updatePasswordPolicy(entry, false);
    }

    public void entryDeleted(DeleteOperationContext deleteContext) {
        Entry entry = deleteContext.getEntry();
        this.updatePasswordPolicy(entry, true);
    }

    public void entryModified(ModifyOperationContext modifyContext) {
        Entry entry = modifyContext.getAlteredEntry();
        this.updatePasswordPolicy(entry, false);
    }

    private void updatePasswordPolicy(Entry entry, boolean deleted) {
        Dn dn = entry.getDn();
        if (!dn.isDescendantOf(this.ppolicyConfigDnRoot)) {
            return;
        }
        if (!entry.contains(new Attribute[]{this.passwordPolicyObjectClassAttribute})) {
            return;
        }
        if (deleted) {
            LOG.debug("Deleting ppolicy config {}", (Object)dn);
            this.ppolicyConfigContainer.removePolicyConfig(dn);
            return;
        }
        PasswordPolicyBean bean = null;
        try {
            bean = (PasswordPolicyBean)this.cpReader.readConfig(entry);
        }
        catch (Exception e) {
            LOG.warn("Failed to read the updated ppolicy configuration from {}", (Object)dn);
            LOG.warn("", (Throwable)e);
            return;
        }
        if (bean.isDisabled()) {
            LOG.debug("Deleting disabled ppolicy config {}", (Object)dn);
            this.ppolicyConfigContainer.removePolicyConfig(dn);
        } else {
            PasswordPolicyConfiguration updated = ServiceBuilder.createPwdPolicyConfig(bean);
            PasswordPolicyConfiguration existing = this.ppolicyConfigContainer.getPolicyConfig(dn);
            if (existing == null) {
                LOG.debug("Adding ppolicy config {}", (Object)dn);
            } else {
                LOG.debug("Updating ppolicy config {}", (Object)dn);
            }
            this.ppolicyConfigContainer.addPolicy(dn, updated);
        }
    }
}

