/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.config;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.config.ConfigSchemaConstants;
import org.apache.directory.server.config.ConfigurationException;
import org.apache.directory.server.config.beans.AdsBaseBean;
import org.apache.directory.server.config.beans.ConfigBean;
import org.apache.directory.server.core.partition.impl.btree.AbstractBTreePartition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.search.SearchEngine;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.filter.EqualityNode;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.ObjectClass;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigPartitionReader {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigPartitionReader.class);
    private AbstractBTreePartition<Long> configPartition;
    private SearchEngine<Entry, Long> se;
    private SchemaManager schemaManager;
    private static final String ADS_PREFIX = "ads-";
    private static final String ADS_SUFFIX = "Bean";
    private static final boolean MANDATORY = true;
    private static final boolean OPTIONNAL = false;

    public ConfigPartitionReader(AbstractBTreePartition<Long> configPartition) {
        if (configPartition == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_503, (Object[])new Object[0]));
        }
        if (!configPartition.isInitialized()) {
            throw new IllegalStateException(I18n.err((I18n)I18n.ERR_504, (Object[])new Object[0]));
        }
        this.configPartition = configPartition;
        this.se = configPartition.getSearchEngine();
        this.schemaManager = configPartition.getSchemaManager();
    }

    private ObjectClass findObjectClass(Attribute objectClass) throws Exception {
        ObjectClass oc;
        String ocOid;
        String ocName;
        HashSet<ObjectClass> candidates = new HashSet<ObjectClass>();
        try {
            for (Value ocValue : objectClass) {
                ocName = ocValue.getString();
                ocOid = this.schemaManager.getObjectClassRegistry().getOidByName(ocName);
                oc = (ObjectClass)this.schemaManager.getObjectClassRegistry().get(ocOid);
                if (!oc.isStructural()) continue;
                candidates.add(oc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        for (Value ocValue : objectClass) {
            ocName = ocValue.getString();
            ocOid = this.schemaManager.getObjectClassRegistry().getOidByName(ocName);
            oc = (ObjectClass)this.schemaManager.getObjectClassRegistry().get(ocOid);
            for (ObjectClass superior : oc.getSuperiors()) {
                if (!oc.isStructural() || !candidates.contains(superior)) continue;
                candidates.remove(superior);
            }
        }
        ObjectClass result = candidates.toArray(new ObjectClass[0])[0];
        LOG.debug("The top level object class is {}", (Object)result.getName());
        return result;
    }

    private AdsBaseBean createBean(ObjectClass objectClass) throws ConfigurationException {
        String objectClassName = objectClass.getName();
        String beanName = this.getClass().getPackage().getName() + ".beans." + Character.toUpperCase(objectClassName.charAt(ADS_PREFIX.length())) + objectClassName.substring(ADS_PREFIX.length() + 1) + ADS_SUFFIX;
        try {
            Class<?> clazz = Class.forName(beanName);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            AdsBaseBean bean = (AdsBaseBean)constructor.newInstance(new Object[0]);
            LOG.debug("Bean {} created for ObjectClass {}", (Object)beanName, (Object)objectClassName);
            return bean;
        }
        catch (ClassNotFoundException cnfe) {
            String message = "Cannot find a Bean class for the ObjectClass name " + objectClassName;
            LOG.error(message);
            throw new ConfigurationException(message);
        }
        catch (SecurityException se) {
            String message = "Cannot access to the class " + beanName;
            LOG.error(message);
            throw new ConfigurationException(message);
        }
        catch (NoSuchMethodException nsme) {
            String message = "Cannot find a constructor for the class " + beanName;
            LOG.error(message);
            throw new ConfigurationException(message);
        }
        catch (InvocationTargetException ite) {
            String message = "Cannot invoke the class " + beanName + ", " + ite.getMessage();
            LOG.error(message);
            throw new ConfigurationException(message);
        }
        catch (IllegalAccessException iae) {
            String message = "Cannot access to the constructor for class " + beanName;
            LOG.error(message);
            throw new ConfigurationException(message);
        }
        catch (InstantiationException ie) {
            String message = "Cannot instanciate the class " + beanName + ", " + ie.getMessage();
            LOG.error(message);
            throw new ConfigurationException(message);
        }
    }

    private static Field getField(Class<?> clazz, String attributeName, Class<?> originalClazz) throws ConfigurationException {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            String fieldName = field.getName();
            if (!fieldName.equalsIgnoreCase(attributeName)) continue;
            return field;
        }
        if (clazz.getSuperclass() != null) {
            return ConfigPartitionReader.getField(clazz.getSuperclass(), attributeName, originalClazz);
        }
        String message = "Cannot find a field named " + attributeName + " in class " + originalClazz.getName();
        LOG.error(message);
        throw new ConfigurationException(message);
    }

    private void readSingleValueField(AdsBaseBean bean, Field beanField, Attribute fieldAttr, boolean mandatory) throws ConfigurationException {
        block11: {
            if (fieldAttr == null) {
                return;
            }
            Value value = fieldAttr.get();
            String valueStr = value.getString();
            Class<?> type = beanField.getType();
            try {
                if (type == String.class) {
                    beanField.set(bean, value.getString());
                    break block11;
                }
                if (type == byte[].class) {
                    beanField.set(bean, value.getBytes());
                    break block11;
                }
                if (type == Integer.TYPE) {
                    beanField.setInt(bean, Integer.parseInt(valueStr));
                    break block11;
                }
                if (type == Long.TYPE) {
                    beanField.setLong(bean, Long.parseLong(valueStr));
                    break block11;
                }
                if (type == Boolean.TYPE) {
                    beanField.setBoolean(bean, Boolean.parseBoolean(valueStr));
                    break block11;
                }
                if (type != Dn.class) break block11;
                try {
                    Dn dn = new Dn(new String[]{valueStr});
                    beanField.set(bean, dn);
                }
                catch (LdapInvalidDnException lide) {
                    String message = "The Dn '" + valueStr + "' for attribute " + fieldAttr.getId() + " is not a valid Dn";
                    LOG.error(message);
                    throw new ConfigurationException(message);
                }
            }
            catch (IllegalArgumentException iae) {
                String message = "Cannot store '" + valueStr + "' into attribute " + fieldAttr.getId();
                LOG.error(message);
                throw new ConfigurationException(message);
            }
            catch (IllegalAccessException e) {
                String message = "Cannot store '" + valueStr + "' into attribute " + fieldAttr.getId();
                LOG.error(message);
                throw new ConfigurationException(message);
            }
        }
    }

    private void readMultiValuedField(AdsBaseBean bean, Field beanField, Attribute fieldAttr, boolean mandatory) throws ConfigurationException {
        if (fieldAttr == null) {
            return;
        }
        Class<?> type = beanField.getType();
        String fieldName = beanField.getName();
        String addMethodName = "add" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        for (Value value : fieldAttr) {
            String message;
            String valueStr = value.getString();
            try {
                Method method;
                Type[] fieldArgTypes;
                ParameterizedType parameterizedType;
                Class fieldArgClass;
                Type genericFieldType;
                if (type == String.class) {
                    beanField.set(bean, valueStr);
                    continue;
                }
                if (type == Integer.TYPE) {
                    beanField.setInt(bean, Integer.parseInt(valueStr));
                    continue;
                }
                if (type == Long.TYPE) {
                    beanField.setLong(bean, Long.parseLong(valueStr));
                    continue;
                }
                if (type == Boolean.TYPE) {
                    beanField.setBoolean(bean, Boolean.parseBoolean(valueStr));
                    continue;
                }
                if (type == Dn.class) {
                    try {
                        Dn dn = new Dn(new String[]{valueStr});
                        beanField.set(bean, dn);
                        continue;
                    }
                    catch (LdapInvalidDnException lide) {
                        message = "The Dn '" + valueStr + "' for attribute " + fieldAttr.getId() + " is not a valid Dn";
                        LOG.error(message);
                        throw new ConfigurationException(message);
                    }
                }
                if (type == Set.class) {
                    genericFieldType = beanField.getGenericType();
                    fieldArgClass = null;
                    if (genericFieldType instanceof ParameterizedType) {
                        parameterizedType = (ParameterizedType)genericFieldType;
                        for (Type fieldArgType : fieldArgTypes = parameterizedType.getActualTypeArguments()) {
                            fieldArgClass = (Class)fieldArgType;
                        }
                    }
                    method = bean.getClass().getMethod(addMethodName, Array.newInstance(fieldArgClass, 0).getClass());
                    method.invoke((Object)bean, new Object[]{new String[]{valueStr}});
                    continue;
                }
                if (type != List.class) continue;
                genericFieldType = beanField.getGenericType();
                fieldArgClass = null;
                if (genericFieldType instanceof ParameterizedType) {
                    parameterizedType = (ParameterizedType)genericFieldType;
                    for (Type fieldArgType : fieldArgTypes = parameterizedType.getActualTypeArguments()) {
                        fieldArgClass = (Class)fieldArgType;
                    }
                }
                method = bean.getClass().getMethod(addMethodName, Array.newInstance(fieldArgClass, 0).getClass());
                method.invoke((Object)bean, new Object[]{new String[]{valueStr}});
            }
            catch (IllegalArgumentException iae) {
                message = "Cannot store '" + valueStr + "' into attribute " + fieldAttr.getId();
                LOG.error(message);
                throw new ConfigurationException(message);
            }
            catch (IllegalAccessException e) {
                message = "Cannot store '" + valueStr + "' into attribute " + fieldAttr.getId();
                LOG.error(message);
                throw new ConfigurationException(message);
            }
            catch (SecurityException se) {
                message = "Cannot access to the class " + bean.getClass().getName();
                LOG.error(message);
                throw new ConfigurationException(message);
            }
            catch (NoSuchMethodException nsme) {
                message = "Cannot find a method " + addMethodName + " in the class " + bean.getClass().getName();
                LOG.error(message);
                throw new ConfigurationException(message);
            }
            catch (InvocationTargetException ite) {
                message = "Cannot invoke the class " + bean.getClass().getName() + ", " + ite.getMessage();
                LOG.error(message);
                throw new ConfigurationException(message);
            }
            catch (NegativeArraySizeException nase) {
            }
        }
    }

    private void readFields(AdsBaseBean bean, Entry entry, Set<AttributeType> attributeTypes, boolean mandatory) throws NoSuchFieldException, IllegalAccessException, Exception {
        for (AttributeType attributeType : attributeTypes) {
            String fieldName;
            String beanFieldName = fieldName = attributeType.getName();
            if (fieldName.startsWith(ADS_PREFIX)) {
                beanFieldName = fieldName.substring(ADS_PREFIX.length());
            }
            Field beanField = ConfigPartitionReader.getField(bean.getClass(), beanFieldName, bean.getClass());
            beanField.setAccessible(true);
            Attribute fieldAttr = entry.get(fieldName);
            if (fieldAttr == null && mandatory) {
                String message = "Attribute " + fieldName + " is mandatory and is not present for the Entry " + entry.getDn();
                LOG.error(message);
                throw new ConfigurationException(message);
            }
            AttributeType beanAT = this.schemaManager.getAttributeType(fieldName);
            AttributeType superior = beanAT.getSuperior();
            if (superior != null && superior.getOid().equals(ConfigSchemaConstants.ADS_COMPOSITE_ELEMENT_AT.getOid())) {
                List<AdsBaseBean> beans;
                String message;
                if (beanAT.isSingleValued()) {
                    List<AdsBaseBean> beans2 = this.read(entry.getDn(), fieldName, SearchScope.ONELEVEL, mandatory);
                    if (beans2 == null || beans2.size() == 0) {
                        if (!mandatory) continue;
                        String message2 = "The composite " + beanAT.getName() + " is mandatory, and was not found under the " + "configuration entry " + entry.getDn();
                        LOG.error(message2);
                        throw new ConfigurationException(message2);
                    }
                    AdsBaseBean readBean = beans2.get(0);
                    if (beans2.size() > 1) {
                        message = "We have more than one entry for " + beanAT.getName() + " under " + entry.getDn();
                        LOG.error(message);
                        throw new ConfigurationException(message);
                    }
                    beanField.set(bean, readBean);
                    continue;
                }
                Dn newBase = entry.getDn().add("ou=" + beanFieldName);
                String attributeName = fieldName.substring(0, fieldName.length() - 1);
                if (!this.schemaManager.getObjectClassRegistry().contains(attributeName)) {
                    attributeName = fieldName.substring(0, fieldName.length() - 2);
                    if (fieldName.endsWith("ies") && !this.schemaManager.getObjectClassRegistry().contains(attributeName)) {
                        attributeName = fieldName.substring(0, fieldName.length() - 3) + "y";
                    }
                    if (!this.schemaManager.getObjectClassRegistry().contains(attributeName)) {
                        message = "Cannot find the ObjectClass named " + attributeName + " in the schema";
                        LOG.error(message);
                        throw new ConfigurationException(message);
                    }
                }
                if ((beans = this.read(newBase, attributeName, SearchScope.ONELEVEL, mandatory)) == null || beans.size() == 0) {
                    if (!mandatory) continue;
                    String message3 = "The composite " + beanAT.getName() + " is mandatory, and was not found under the " + "configuration entry " + entry.getDn();
                    LOG.error(message3);
                    throw new ConfigurationException(message3);
                }
                beanField.set(bean, beans);
                continue;
            }
            if (beanAT.isSingleValued()) {
                this.readSingleValueField(bean, beanField, fieldAttr, mandatory);
                continue;
            }
            this.readMultiValuedField(bean, beanField, fieldAttr, mandatory);
        }
    }

    private Set<AttributeType> getAllMusts(ObjectClass objectClass) {
        HashSet<AttributeType> musts = new HashSet<AttributeType>();
        musts.addAll(objectClass.getMustAttributeTypes());
        List superiors = objectClass.getSuperiors();
        if (superiors != null) {
            for (ObjectClass superior : superiors) {
                musts.addAll(this.getAllMusts(superior));
            }
        }
        return musts;
    }

    private Set<AttributeType> getAllMays(ObjectClass objectClass) {
        HashSet<AttributeType> mays = new HashSet<AttributeType>();
        mays.addAll(objectClass.getMayAttributeTypes());
        List superiors = objectClass.getSuperiors();
        if (superiors != null) {
            for (ObjectClass superior : superiors) {
                mays.addAll(this.getAllMays(superior));
            }
        }
        return mays;
    }

    private String dumpATs(Set<AttributeType> attributeTypes) {
        if (attributeTypes == null || attributeTypes.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        sb.append('{');
        for (AttributeType attributeType : attributeTypes) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(attributeType.getName());
        }
        sb.append('}');
        return sb.toString();
    }

    private List<AdsBaseBean> read(Dn baseDn, String name, SearchScope scope, boolean mandatory) throws ConfigurationException {
        LOG.debug("Reading from '{}', entry {}", (Object)baseDn, (Object)name);
        AttributeType adsdAt = this.schemaManager.getAttributeType("objectClass");
        EqualityNode filter = new EqualityNode(adsdAt, (Value)new StringValue(name));
        IndexCursor cursor = null;
        ArrayList<AdsBaseBean> beans = new ArrayList<AdsBaseBean>();
        try {
            cursor = this.se.cursor(baseDn, AliasDerefMode.NEVER_DEREF_ALIASES, (ExprNode)filter, scope);
            if (!cursor.next()) {
                if (mandatory) {
                    cursor.close();
                    String message = "No directoryService instance was configured under the Dn " + this.configPartition.getSuffixDn();
                    LOG.error(message);
                    throw new ConfigurationException(message);
                }
                List<AdsBaseBean> message = null;
                return message;
            }
            do {
                ForwardIndexEntry forwardEntry = (ForwardIndexEntry)cursor.get();
                Entry entry = this.configPartition.lookup((Comparable)forwardEntry.getId());
                LOG.debug("Entry read : {}", (Object)entry);
                Attribute objectClassAttr = entry.get("objectClass");
                ObjectClass objectClass = this.findObjectClass(objectClassAttr);
                AdsBaseBean bean = this.createBean(objectClass);
                Set<AttributeType> mays = this.getAllMays(objectClass);
                LOG.debug("Fetching the following MAY attributes : {}", (Object)this.dumpATs(mays));
                this.readFields(bean, entry, mays, false);
                Set<AttributeType> musts = this.getAllMusts(objectClass);
                LOG.debug("Fetching the following MAY attributes : {}", (Object)this.dumpATs(musts));
                this.readFields(bean, entry, musts, true);
                bean.setDn(entry.getDn());
                beans.add(bean);
            } while (cursor.next());
        }
        catch (ConfigurationException ce) {
            ce.printStackTrace();
            throw ce;
        }
        catch (Exception e) {
            String message = "Cannot open a cursor to read the configuration on " + baseDn;
            LOG.error(message);
            throw new ConfigurationException(message);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception e) {
                    throw new ConfigurationException(e.getMessage(), e.getCause());
                }
            }
        }
        return beans;
    }

    public ConfigBean readConfig() throws LdapException {
        return this.readConfig(new Dn(new Rdn[]{new Rdn("ou", "config")}));
    }

    public ConfigBean readConfig(String baseDn) throws LdapException {
        return this.readConfig(new Dn(new String[]{baseDn}), ConfigSchemaConstants.ADS_DIRECTORY_SERVICE_OC.getValue());
    }

    public ConfigBean readConfig(Dn baseDn) throws ConfigurationException {
        return this.readConfig(baseDn, ConfigSchemaConstants.ADS_DIRECTORY_SERVICE_OC.getValue());
    }

    public ConfigBean readConfig(String baseDn, String objectClass) throws LdapException {
        return this.readConfig(new Dn(new String[]{baseDn}), objectClass);
    }

    public ConfigBean readConfig(Dn baseDn, String objectClass) throws ConfigurationException {
        LOG.debug("Reading configuration for the {} element, from {} ", (Object)objectClass, (Object)baseDn);
        ConfigBean configBean = new ConfigBean();
        if (baseDn == null) {
            baseDn = this.configPartition.getSuffixDn();
        }
        List<AdsBaseBean> beans = this.read(baseDn, objectClass, SearchScope.ONELEVEL, true);
        if (LOG.isDebugEnabled()) {
            if (beans == null || beans.size() == 0) {
                LOG.debug("No {} element to read", (Object)objectClass);
            } else {
                LOG.debug(beans.get(0).toString());
            }
        }
        configBean.setDirectoryServiceBeans(beans);
        return configBean;
    }
}

