/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.config.beans;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.config.ConfigurationElement;
import org.apache.directory.server.config.beans.DSBasedServerBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangePasswordServerBean
extends DSBasedServerBean {
    @ConfigurationElement(attributeType="ads-krbAllowableClockSkew")
    private long krbAllowableClockSkew;
    @ConfigurationElement(attributeType="ads-krbEmptyAddressesAllowed")
    private boolean krbEmptyAddressesAllowed;
    @ConfigurationElement(attributeType="ads-krbEncryptionTypes")
    private List<String> krbEncryptionTypes = new ArrayList<String>();
    @ConfigurationElement(attributeType="ads-krbPrimaryRealm")
    private String krbPrimaryRealm;
    @ConfigurationElement(attributeType="ads-chgPwdPolicyCategoryCount")
    private int chgPwdPolicyCategoryCount;
    @ConfigurationElement(attributeType="ads-chgPwdPolicyPasswordLength")
    private int chgPwdPolicyPasswordLength;
    @ConfigurationElement(attributeType="ads-chgPwdPolicyTokenSize")
    private int chgPwdPolicyTokenSize;
    @ConfigurationElement(attributeType="ads-chgPwdServicePrincipal")
    private String chgPwdServicePrincipal;

    public long getKrbAllowableClockSkew() {
        return this.krbAllowableClockSkew;
    }

    public void setKrbAllowableClockSkew(long krbAllowableClockSkew) {
        this.krbAllowableClockSkew = krbAllowableClockSkew;
    }

    public boolean isKrbEmptyAddressesAllowed() {
        return this.krbEmptyAddressesAllowed;
    }

    public void setKrbEmptyAddressesAllowed(boolean krbEmptyAddressesAllowed) {
        this.krbEmptyAddressesAllowed = krbEmptyAddressesAllowed;
    }

    public List<String> getKrbEncryptionTypes() {
        return this.krbEncryptionTypes;
    }

    public void setKrbEncryptionTypes(List<String> krbEncryptionTypes) {
        this.krbEncryptionTypes = krbEncryptionTypes;
    }

    public void addKrbEncryptionTypes(String ... krbEncryptionTypes) {
        for (String encryptionType : krbEncryptionTypes) {
            this.krbEncryptionTypes.add(encryptionType);
        }
    }

    public String getKrbPrimaryRealm() {
        return this.krbPrimaryRealm;
    }

    public void setKrbPrimaryRealm(String krbPrimaryRealm) {
        this.krbPrimaryRealm = krbPrimaryRealm;
    }

    public int getChgPwdPolicyCategoryCount() {
        return this.chgPwdPolicyCategoryCount;
    }

    public void setChgPwdPolicyCategoryCount(int chgPwdPolicyCategoryCount) {
        this.chgPwdPolicyCategoryCount = chgPwdPolicyCategoryCount;
    }

    public int getChgPwdPolicyPasswordLength() {
        return this.chgPwdPolicyPasswordLength;
    }

    public void setChgPwdPolicyPasswordLength(int chgPwdPolicyPasswordLength) {
        this.chgPwdPolicyPasswordLength = chgPwdPolicyPasswordLength;
    }

    public int getChgPwdPolicyTokenSize() {
        return this.chgPwdPolicyTokenSize;
    }

    public void setChgPwdPolicyTokenSize(int chgPwdPolicyTokenSize) {
        this.chgPwdPolicyTokenSize = chgPwdPolicyTokenSize;
    }

    public String getChgPwdServicePrincipal() {
        return this.chgPwdServicePrincipal;
    }

    public void setChgPwdServicePrincipal(String chgPwdServicePrincipal) {
        this.chgPwdServicePrincipal = chgPwdServicePrincipal;
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("ChangePasswordServer :\n");
        sb.append(super.toString(tabs + "  "));
        sb.append(this.toString(tabs, "  change password service principal", this.chgPwdServicePrincipal));
        sb.append(this.toString(tabs, "  KRB primary realm", this.krbPrimaryRealm));
        if (this.krbEncryptionTypes != null && this.krbEncryptionTypes.size() != 0) {
            sb.append(tabs).append("  encryption types : \n");
            for (String encryptionType : this.krbEncryptionTypes) {
                sb.append(tabs).append("    encryptionType : ").append(encryptionType).append('\n');
            }
        }
        sb.append(this.toString(tabs, "  change password policy category count", this.chgPwdPolicyCategoryCount));
        sb.append(this.toString(tabs, "  change password policy password length", this.chgPwdPolicyPasswordLength));
        sb.append(this.toString(tabs, "  change password policy token size", this.chgPwdPolicyTokenSize));
        sb.append(this.toString(tabs, "  KRB allowable clock skew", this.krbAllowableClockSkew));
        sb.append(this.toString(tabs, "  KRB empty addresses allowed", this.krbEmptyAddressesAllowed));
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toString("");
    }
}

