/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.bootstrap;

import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.server.schema.bootstrap.AbstractBootstrapProducer;
import org.apache.directory.server.schema.bootstrap.BootstrapProducer;
import org.apache.directory.server.schema.bootstrap.ProducerCallback;
import org.apache.directory.server.schema.bootstrap.ProducerTypeEnum;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.UsageEnum;

public class DhcpAttributeTypeProducer
extends AbstractBootstrapProducer {
    public DhcpAttributeTypeProducer() {
        super(ProducerTypeEnum.ATTRIBUTE_TYPE_PRODUCER);
    }

    public void produce(Registries registries, ProducerCallback cb) throws NamingException {
        ArrayList<String> names = new ArrayList<String>();
        AbstractBootstrapProducer.BootstrapAttributeType attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.1", (Registries)registries);
        attributeType.setDescription("The DN of the dhcpServer which is the primary server for the configuration.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("distinguishedNameMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.12");
        names.clear();
        names.add("dhcpPrimaryDN");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.1", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.2", (Registries)registries);
        attributeType.setDescription("The DN of dhcpServer(s) which provide backup service for the configuration.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("distinguishedNameMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.12");
        names.clear();
        names.add("dhcpSecondaryDN");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.2", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.3", (Registries)registries);
        attributeType.setDescription("Flexible storage for specific data depending on what object this exists in. Like conditional statements, server parameters, etc. This allows the standard to evolve without needing to adjust the schema.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("dhcpStatements");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.3", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.4", (Registries)registries);
        attributeType.setDescription("The starting & ending IP Addresses in the range (inclusive), separated by a hyphen; if the range only contains one address, then just the address can be specified with no hyphen.  Each range is defined as a separate value.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("dhcpRange");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.4", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.5", (Registries)registries);
        attributeType.setDescription("This attribute contains the permit lists associated with a pool. Each permit list is defined as a separate value.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("dhcpPermitList");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.5", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.6", (Registries)registries);
        attributeType.setDescription("The subnet mask length for the subnet.  The mask can be easily computed from this length.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.27");
        names.clear();
        names.add("dhcpNetMask");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.6", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.7", (Registries)registries);
        attributeType.setDescription("Encoded option values to be sent to clients.  Each value represents a single option and contains (OptionTag, Length, OptionValue) encoded in the format used by DHCP.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.40");
        names.clear();
        names.add("dhcpOption");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.7", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.8", (Registries)registries);
        attributeType.setDescription("Encoded text string or list of bytes expressed in hexadecimal, separated by colons.  Clients match subclasses based on matching the class data with the results of match or spawn with statements in the class name declarations.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("dhcpClassData");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.8", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.9", (Registries)registries);
        attributeType.setDescription("The distinguished name(s) of the dhcpOption objects containing the configuration options provided by the server.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("distinguishedNameMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.12");
        names.clear();
        names.add("dhcpOptionsDN");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.9", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.10", (Registries)registries);
        attributeType.setDescription("the distinguished name(s) of the dhcpHost objects.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("distinguishedNameMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.12");
        names.clear();
        names.add("dhcpHostDN");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.10", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.11", (Registries)registries);
        attributeType.setDescription("The distinguished name(s) of pools.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("distinguishedNameMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.12");
        names.clear();
        names.add("dhcpPoolDN");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.11", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.12", (Registries)registries);
        attributeType.setDescription("The distinguished name(s)   of the groups.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("distinguishedNameMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.12");
        names.clear();
        names.add("dhcpGroupDN");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.12", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.13", (Registries)registries);
        attributeType.setDescription("The distinguished name(s) of the subnets.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("distinguishedNameMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.12");
        names.clear();
        names.add("dhcpSubnetDN");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.13", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.14", (Registries)registries);
        attributeType.setDescription("The distinguished name of a client address.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("distinguishedNameMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.12");
        names.clear();
        names.add("dhcpLeaseDN");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.14", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.15", (Registries)registries);
        attributeType.setDescription("The distinguished name(s) client addresses.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("distinguishedNameMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.12");
        names.clear();
        names.add("dhcpLeasesDN");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.15", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.16", (Registries)registries);
        attributeType.setDescription("The distinguished name(s) of a class(es) in a subclass.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("distinguishedNameMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.12");
        names.clear();
        names.add("dhcpClassesDN");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.16", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.17", (Registries)registries);
        attributeType.setDescription("The distinguished name(s) of subclass(es).");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("distinguishedNameMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.12");
        names.clear();
        names.add("dhcpSubclassesDN");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.17", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.18", (Registries)registries);
        attributeType.setDescription("The distinguished name(s) of sharedNetworks.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("distinguishedNameMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.12");
        names.clear();
        names.add("dhcpSharedNetworkDN");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.18", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.19", (Registries)registries);
        attributeType.setDescription("The DN of dhcpService object(s)which contain the configuration information. Each dhcpServer object has this attribute identifying the DHCP configuration(s) that the server is associated with.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("distinguishedNameMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.12");
        names.clear();
        names.add("dhcpServiceDN");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.19", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.20", (Registries)registries);
        attributeType.setDescription("The version attribute of this object.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("dhcpVersion");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.20", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.21", (Registries)registries);
        attributeType.setDescription("Description of the DHCP Server implementation e.g. DHCP Servers vendor.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("dhcpImplementation");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.21", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.22", (Registries)registries);
        attributeType.setDescription("This stores information about the current binding-status of an address.  For dynamic addresses managed by DHCP, the values should be restricted to the following: \"FREE\", \"ACTIVE\", \"EXPIRED\", \"RELEASED\", \"RESET\", \"ABANDONED\", \"BACKUP\".  For other addresses, it SHOULD be one of the following: \"UNKNOWN\", \"RESERVED\" (an address that is managed by DHCP that is reserved for a specific client), \"RESERVED-ACTIVE\" (same as reserved, but address is currently in use), \"ASSIGNED\" (assigned manually or by some other mechanism), \"UNASSIGNED\", \"NOTASSIGNABLE\".");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("dhcpAddressState");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.22", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.23", (Registries)registries);
        attributeType.setDescription("This is the time the current lease for an address expires.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.24");
        names.clear();
        names.add("dhcpExpirationTime");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.23", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.24", (Registries)registries);
        attributeType.setDescription("This is the time of the last state change for a leased address.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.24");
        names.clear();
        names.add("dhcpStartTimeOfState");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.24", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.25", (Registries)registries);
        attributeType.setDescription("This is the last time a valid DHCP packet was received from the client.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.24");
        names.clear();
        names.add("dhcpLastTransactionTime");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.25", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.26", (Registries)registries);
        attributeType.setDescription("This indicates whether the address was assigned via BOOTP.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.7");
        names.clear();
        names.add("dhcpBootpFlag");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.26", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.27", (Registries)registries);
        attributeType.setDescription("This is the name of the domain sent to the client by the server.  It is essentially the same as the value for DHCP option 15 sent to the client, and represents only the domain - not the full FQDN.  To obtain the full FQDN assigned to the client you must prepend the \"dhcpAssignedHostName\" to this value with a \".\".");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("dhcpDomainName");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.27", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.28", (Registries)registries);
        attributeType.setDescription("This indicates the status of updating DNS resource records on behalf of the client by the DHCP server for this address.  The value is a 16-bit bitmask.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.27");
        names.clear();
        names.add("dhcpDnsStatus");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.28", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.29", (Registries)registries);
        attributeType.setDescription("This is the hostname that was requested by the client.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("dhcpRequestedHostName");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.29", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.30", (Registries)registries);
        attributeType.setDescription("This is the actual hostname that was assigned to a client. It may not be the name that was requested by the client.  The fully qualified domain name can be determined by appending the value of \"dhcpDomainName\" (with a dot separator) to this name.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("dhcpAssignedHostName");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.30", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.31", (Registries)registries);
        attributeType.setDescription("The distinguished name of a \"dhcpClient\" that an address is reserved for.  This may not be the same as the \"dhcpAssignedToClient\" attribute if the address is being reassigned but the current lease has not yet expired.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("distinguishedNameMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.12");
        names.clear();
        names.add("dhcpReservedForClient");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.31", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.32", (Registries)registries);
        attributeType.setDescription("This is the distinguished name of a \"dhcpClient\" that an address is currently assigned to.  This attribute is only present in the class when the address is leased.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("distinguishedNameMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.12");
        names.clear();
        names.add("dhcpAssignedToClient");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.32", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.33", (Registries)registries);
        attributeType.setDescription("If the client request was received via a relay agent, this contains information about the relay agent that was available from the DHCP request.  This is a hex-encoded option value.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.40");
        names.clear();
        names.add("dhcpRelayAgentInfo");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.33", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.34", (Registries)registries);
        attributeType.setDescription("The clients hardware address that requested this IP address.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.40");
        names.clear();
        names.add("dhcpHWAddress");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.34", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.35", (Registries)registries);
        attributeType.setDescription("HashBucketAssignment bit map for the DHCP Server, as defined in DHC Load Balancing Algorithm [RFC 3074].");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.40");
        names.clear();
        names.add("dhcpHashBucketAssignment");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.35", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.36", (Registries)registries);
        attributeType.setDescription("Delay in seconds corresponding to Delayed Service Parameter configuration, as defined in  DHC Load Balancing Algorithm [RFC 3074]. ");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.27");
        names.clear();
        names.add("dhcpDelayedServiceParameter");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.36", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.37", (Registries)registries);
        attributeType.setDescription("Maximum Client Lead Time configuration in seconds, as defined in DHCP Failover Protocol [FAILOVR]");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.27");
        names.clear();
        names.add("dhcpMaxClientLeadTime");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.37", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.38", (Registries)registries);
        attributeType.setDescription("Server (Failover Endpoint) state, as defined in DHCP Failover Protocol [FAILOVR]");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("dhcpFailOverEndpointState");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.38", (Object)attributeType);
        attributeType = DhcpAttributeTypeProducer.newAttributeType((String)"2.16.840.1.113719.1.203.4.39", (Registries)registries);
        attributeType.setDescription("Generic error log attribute that allows logging error conditions within a dhcpService or a dhcpSubnet, like no IP addresses available for lease.");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"USER_APPLICATIONS"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("dhcpErrorLog");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced((BootstrapProducer)this, "2.16.840.1.113719.1.203.4.39", (Object)attributeType);
    }
}

