
/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;

import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.UsageEnum;


/**
 * A producer of schema attributeType definations for the core schema.  This
 * code has been automatically generated using schema files in the OpenLDAP
 * format along with the directory plugin for maven.  This has been done
 * to facilitate Eve<->OpenLDAP schema interoperability.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class CoreAttributeTypeProducer extends AbstractBootstrapProducer
{

    public CoreAttributeTypeProducer()
    {
        super( ProducerTypeEnum.ATTRIBUTE_TYPE_PRODUCER );
    }


    // ------------------------------------------------------------------------
    // BootstrapProducer Methods
    // ------------------------------------------------------------------------


    /**
     * @see BootstrapProducer#produce( Registries, ProducerCallback )
     */
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> names = new ArrayList<String>();
        BootstrapAttributeType attributeType;


        // --------------------------------------------------------------------
        // AttributeType 2.5.4.2 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.2", registries );
        attributeType.setDescription( "RFC2256: knowledge information" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 32768 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "knowledgeInformation" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.2", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.4 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.4", registries );
        attributeType.setDescription( "RFC2256: last (family) name(s) for which the entity is known by" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "name" );

        names.clear();
        names.add( "sn" );
        names.add( "surname" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.4", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.5 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.5", registries );
        attributeType.setDescription( "RFC2256: serial number of the entity" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 64 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.44" );

        names.clear();
        names.add( "serialNumber" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.5", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.6 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.6", registries );
        attributeType.setDescription( "RFC2256: ISO-3166 country 2-letter code" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "name" );

        names.clear();
        names.add( "c" );
        names.add( "countryName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.6", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.7 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.7", registries );
        attributeType.setDescription( "RFC2256: locality which this object resides in" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "name" );

        names.clear();
        names.add( "l" );
        names.add( "localityName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.7", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.8 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.8", registries );
        attributeType.setDescription( "RFC2256: state or province which this object resides in" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "name" );

        names.clear();
        names.add( "st" );
        names.add( "stateOrProvinceName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.8", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.9 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.9", registries );
        attributeType.setDescription( "RFC2256: street address of this object" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 128 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "street" );
        names.add( "streetAddress" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.9", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.10 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.10", registries );
        attributeType.setDescription( "RFC2256: organization this object belongs to" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "name" );

        names.clear();
        names.add( "o" );
        names.add( "organizationName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.10", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.11 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.11", registries );
        attributeType.setDescription( "RFC2256: organizational unit this object belongs to" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "name" );

        names.clear();
        names.add( "ou" );
        names.add( "organizationalUnitName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.11", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.12 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.12", registries );
        attributeType.setDescription( "RFC2256: title associated with the entity" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "name" );

        names.clear();
        names.add( "title" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.12", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.13 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.13", registries );
        attributeType.setDescription( "RFC2256: descriptive information" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 1024 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "description" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.13", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.14 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.14", registries );
        attributeType.setDescription( "RFC2256: search guide, obsoleted by enhancedSearchGuide" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.25" );

        names.clear();
        names.add( "searchGuide" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.14", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.15 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.15", registries );
        attributeType.setDescription( "RFC2256: business category" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 128 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "businessCategory" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.15", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.16 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.16", registries );
        attributeType.setDescription( "RFC2256: postal address" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreListMatch" );
        attributeType.setSubstrId( "caseIgnoreListSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.41" );

        names.clear();
        names.add( "postalAddress" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.16", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.17 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.17", registries );
        attributeType.setDescription( "RFC2256: postal code" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 40 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "postalCode" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.17", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.18 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.18", registries );
        attributeType.setDescription( "RFC2256: Post Office Box" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 40 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "postOfficeBox" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.18", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.19 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.19", registries );
        attributeType.setDescription( "RFC2256: Physical Delivery Office Name" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 128 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "physicalDeliveryOfficeName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.19", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.20 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.20", registries );
        attributeType.setDescription( "RFC2256: Telephone Number" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 32 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "telephoneNumberMatch" );
        attributeType.setSubstrId( "telephoneNumberSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.50" );

        names.clear();
        names.add( "telephoneNumber" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.20", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.21 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.21", registries );
        attributeType.setDescription( "RFC2256: Telex Number" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.52" );

        names.clear();
        names.add( "telexNumber" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.21", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.22 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.22", registries );
        attributeType.setDescription( "RFC2256: Teletex Terminal Identifier" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.51" );

        names.clear();
        names.add( "teletexTerminalIdentifier" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.22", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.23 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.23", registries );
        attributeType.setDescription( "RFC2256: Facsimile (Fax) Telephone Number" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.22" );

        names.clear();
        names.add( "facsimileTelephoneNumber" );
        names.add( "fax" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.23", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.24 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.24", registries );
        attributeType.setDescription( "RFC2256: X.121 Address" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 15 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "numericStringMatch" );
        attributeType.setSubstrId( "numericStringSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.36" );

        names.clear();
        names.add( "x121Address" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.24", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.25 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.25", registries );
        attributeType.setDescription( "RFC2256: international ISDN number" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 16 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "numericStringMatch" );
        attributeType.setSubstrId( "numericStringSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.36" );

        names.clear();
        names.add( "internationaliSDNNumber" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.25", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.26 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.26", registries );
        attributeType.setDescription( "RFC2256: registered postal address" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "postalAddress" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.41" );

        names.clear();
        names.add( "registeredAddress" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.26", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.27 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.27", registries );
        attributeType.setDescription( "RFC2256: destination indicator" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 128 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.44" );

        names.clear();
        names.add( "destinationIndicator" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.27", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.28 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.28", registries );
        attributeType.setDescription( "RFC2256: preferred delivery method" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.14" );

        names.clear();
        names.add( "preferredDeliveryMethod" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.28", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.29 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.29", registries );
        attributeType.setDescription( "RFC2256: presentation address" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "presentationAddressMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.43" );

        names.clear();
        names.add( "presentationAddress" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.29", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.30 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.30", registries );
        attributeType.setDescription( "RFC2256: supported application context" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "objectIdentifierMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.38" );

        names.clear();
        names.add( "supportedApplicationContext" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.30", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.31 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.31", registries );
        attributeType.setDescription( "RFC2256: member of a group" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "distinguishedName" );

        names.clear();
        names.add( "member" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.31", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.32 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.32", registries );
        attributeType.setDescription( "RFC2256: owner (of the object)" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "distinguishedName" );

        names.clear();
        names.add( "owner" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.32", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.33 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.33", registries );
        attributeType.setDescription( "RFC2256: occupant of role" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "distinguishedName" );

        names.clear();
        names.add( "roleOccupant" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.33", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.34 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.34", registries );
        attributeType.setDescription( "RFC2256: DN of related object" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "distinguishedName" );

        names.clear();
        names.add( "seeAlso" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.34", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.36 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.36", registries );
        attributeType.setDescription( "RFC2256: X.509 user certificate, use ;binary" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.8" );

        names.clear();
        names.add( "userCertificate" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.36", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.37 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.37", registries );
        attributeType.setDescription( "RFC2256: X.509 CA certificate, use ;binary" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.8" );

        names.clear();
        names.add( "cACertificate" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.37", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.38 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.38", registries );
        attributeType.setDescription( "RFC2256: X.509 authority revocation list, use ;binary" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.9" );

        names.clear();
        names.add( "authorityRevocationList" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.38", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.39 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.39", registries );
        attributeType.setDescription( "RFC2256: X.509 certificate revocation list, use ;binary" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.9" );

        names.clear();
        names.add( "certificateRevocationList" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.39", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.40 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.40", registries );
        attributeType.setDescription( "RFC2256: X.509 cross certificate pair, use ;binary" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.10" );

        names.clear();
        names.add( "crossCertificatePair" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.40", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.42 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.42", registries );
        attributeType.setDescription( "RFC2256: first name(s) for which the entity is known by" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "name" );

        names.clear();
        names.add( "givenName" );
        names.add( "gn" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.42", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.43 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.43", registries );
        attributeType.setDescription( "RFC2256: initials of some or all of names, but not the surname(s)." );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "name" );

        names.clear();
        names.add( "initials" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.43", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.44 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.44", registries );
        attributeType.setDescription( "RFC2256: name qualifier indicating a generation" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "name" );

        names.clear();
        names.add( "generationQualifier" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.44", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.45 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.45", registries );
        attributeType.setDescription( "RFC2256: X.500 unique identifier" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "bitStringMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.6" );

        names.clear();
        names.add( "x500UniqueIdentifier" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.45", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.46 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.46", registries );
        attributeType.setDescription( "RFC2256: DN qualifier" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setOrderingId( "caseIgnoreOrderingMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.44" );

        names.clear();
        names.add( "dnQualifier" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.46", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.47 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.47", registries );
        attributeType.setDescription( "RFC2256: enhanced search guide" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.21" );

        names.clear();
        names.add( "enhancedSearchGuide" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.47", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.48 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.48", registries );
        attributeType.setDescription( "RFC2256: protocol information" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "protocolInformationMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.42" );

        names.clear();
        names.add( "protocolInformation" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.48", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.50 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.50", registries );
        attributeType.setDescription( "RFC2256: unique member of a group" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "uniqueMemberMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.34" );

        names.clear();
        names.add( "uniqueMember" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.50", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.51 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.51", registries );
        attributeType.setDescription( "RFC2256: house identifier" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 32768 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "houseIdentifier" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.51", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.52 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.52", registries );
        attributeType.setDescription( "RFC2256: supported algorithms" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.49" );

        names.clear();
        names.add( "supportedAlgorithms" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.52", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.53 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.53", registries );
        attributeType.setDescription( "RFC2256: delta revocation list; use ;binary" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.9" );

        names.clear();
        names.add( "deltaRevocationList" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.53", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 2.5.4.54 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "2.5.4.54", registries );
        attributeType.setDescription( "RFC2256: name of DMD" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setSuperiorId( "name" );

        names.clear();
        names.add( "dmdName" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "2.5.4.54", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.1 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.1", registries );
        attributeType.setDescription( "RFC1274: user identifier" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreMatch" );
        attributeType.setSubstrId( "caseIgnoreSubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.15" );

        names.clear();
        names.add( "uid" );
        names.add( "userid" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.1", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.3 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.3", registries );
        attributeType.setDescription( "RFC1274: RFC822 Mailbox" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 256 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSubstrId( "caseIgnoreIA5SubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "mail" );
        names.add( "rfc822Mailbox" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.3", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.25 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.25", registries );
        attributeType.setDescription( "RFC1274/2247: domain component" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( true );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSubstrId( "caseIgnoreIA5SubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "dc" );
        names.add( "domainComponent" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.25", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 0.9.2342.19200300.100.1.37 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "0.9.2342.19200300.100.1.37", registries );
        attributeType.setDescription( "RFC1274: domain associated with object" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 0 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSubstrId( "caseIgnoreIA5SubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "associatedDomain" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "0.9.2342.19200300.100.1.37", attributeType );

        // --------------------------------------------------------------------
        // AttributeType 1.2.840.113549.1.9.1 
        // --------------------------------------------------------------------

        attributeType = newAttributeType( "1.2.840.113549.1.9.1", registries );
        attributeType.setDescription( "RFC2459: legacy attribute for email addresses in DNs" );
        attributeType.setCanUserModify( ! false );
        attributeType.setSingleValue( false );
        attributeType.setCollective( false );
        attributeType.setObsolete( false );
        attributeType.setLength( 128 );
        attributeType.setUsage( UsageEnum.getUsage( "USER_APPLICATIONS" ) );
        attributeType.setEqualityId( "caseIgnoreIA5Match" );
        attributeType.setSubstrId( "caseIgnoreIA5SubstringsMatch" );
        attributeType.setSyntaxId( "1.3.6.1.4.1.1466.115.121.1.26" );

        names.clear();
        names.add( "email" );
        names.add( "emailAddress" );
        names.add( "pkcs9email" );
        attributeType.setNames( names.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.2.840.113549.1.9.1", attributeType );
    }
}
