/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.bootstrap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import javax.naming.NamingException;
import org.apache.directory.server.schema.bootstrap.AbstractBootstrapProducer;
import org.apache.directory.server.schema.bootstrap.BootstrapProducer;
import org.apache.directory.server.schema.bootstrap.BootstrapSchema;
import org.apache.directory.server.schema.bootstrap.ProducerCallback;
import org.apache.directory.server.schema.bootstrap.ProducerTypeEnum;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.bootstrap.SystemSchema;
import org.apache.directory.server.schema.registries.AbstractSchemaLoader;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.ComparatorRegistry;
import org.apache.directory.server.schema.registries.DefaultRegistries;
import org.apache.directory.server.schema.registries.MatchingRuleRegistry;
import org.apache.directory.server.schema.registries.NormalizerRegistry;
import org.apache.directory.server.schema.registries.ObjectClassRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.schema.registries.SyntaxCheckerRegistry;
import org.apache.directory.server.schema.registries.SyntaxRegistry;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.syntax.ComparatorDescription;
import org.apache.directory.shared.ldap.schema.syntax.NormalizerDescription;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxChecker;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxCheckerDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootstrapSchemaLoader
extends AbstractSchemaLoader {
    private static final Logger log = LoggerFactory.getLogger(BootstrapSchemaLoader.class);
    private ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
    private ThreadLocal<BootstrapSchema> schemas;
    private ThreadLocal<Registries> registries;
    private final ProducerCallback cb = new ProducerCallback(){

        public void schemaObjectProduced(BootstrapProducer producer, String registryKey, Object schemaObject) throws NamingException {
            BootstrapSchemaLoader.this.register(producer.getType(), registryKey, schemaObject);
        }
    };

    public BootstrapSchemaLoader() {
        this.schemas = new ThreadLocal();
        this.registries = new ThreadLocal();
    }

    public BootstrapSchemaLoader(ClassLoader cl) {
        this();
        this.cl = cl;
    }

    public final void loadWithDependencies(Schema schema, Registries registries) throws NamingException {
        if (!(schema instanceof BootstrapSchema)) {
            throw new NamingException("Expecting schema to be of sub-type BootstrapSchema");
        }
        HashMap<String, Schema> notLoaded = new HashMap<String, Schema>();
        notLoaded.put(schema.getSchemaName(), schema);
        Properties props = new Properties();
        props.put("package", ((BootstrapSchema)schema).getPackageName());
        this.loadDepsFirst(schema, new Stack(), notLoaded, schema, registries, props);
    }

    public final void loadWithDependencies(Collection<Schema> bootstrapSchemas, Registries registries) throws NamingException {
        BootstrapSchema[] schemas = new BootstrapSchema[bootstrapSchemas.size()];
        schemas = bootstrapSchemas.toArray(schemas);
        HashMap<String, SystemSchema> loaded = new HashMap<String, SystemSchema>();
        HashMap<String, BootstrapSchema> notLoaded = new HashMap<String, BootstrapSchema>();
        for (int ii = 0; ii < schemas.length; ++ii) {
            notLoaded.put(schemas[ii].getSchemaName(), schemas[ii]);
        }
        SystemSchema schema = new SystemSchema();
        this.load((Schema)schema, registries, false);
        notLoaded.remove(schema.getSchemaName());
        loaded.put(schema.getSchemaName(), schema);
        Iterator list = notLoaded.values().iterator();
        while (list.hasNext()) {
            schema = (BootstrapSchema)list.next();
            Properties props = new Properties();
            props.put("package", schema.getPackageName());
            this.loadDepsFirst((Schema)schema, new Stack(), notLoaded, (Schema)schema, registries, props);
            list = notLoaded.values().iterator();
        }
    }

    public final void load(Schema schema, Registries registries, boolean isDepLoad) throws NamingException {
        if (registries.getLoadedSchemas().containsKey(schema.getSchemaName())) {
            return;
        }
        if (!(schema instanceof BootstrapSchema)) {
            throw new NamingException("Expecting schema to be of sub-type BootstrapSchema");
        }
        this.registries.set(registries);
        this.schemas.set((BootstrapSchema)schema);
        for (ProducerTypeEnum producerType : ProducerTypeEnum.getList()) {
            BootstrapProducer producer = this.getProducer((BootstrapSchema)schema, producerType.getName());
            producer.produce(registries, this.cb);
        }
        this.notifyListenerOrRegistries(schema, registries);
    }

    private void register(ProducerTypeEnum type, String id, Object schemaObject) throws NamingException {
        BootstrapSchema schema = this.schemas.get();
        DefaultRegistries registries = (DefaultRegistries)this.registries.get();
        ArrayList<String> values = new ArrayList<String>(1);
        values.add(schema.getSchemaName());
        switch (type) {
            case NORMALIZER_PRODUCER: {
                Normalizer normalizer = (Normalizer)schemaObject;
                NormalizerRegistry normalizerRegistry = registries.getNormalizerRegistry();
                NormalizerDescription normalizerDescription = new NormalizerDescription();
                normalizerDescription.setNumericOid(id);
                normalizerDescription.setFqcn(normalizer.getClass().getName());
                normalizerDescription.addExtension("X-SCHEMA", values);
                normalizerRegistry.register(normalizerDescription, normalizer);
                break;
            }
            case COMPARATOR_PRODUCER: {
                Comparator comparator = (Comparator)schemaObject;
                ComparatorRegistry comparatorRegistry = registries.getComparatorRegistry();
                ComparatorDescription comparatorDescription = new ComparatorDescription();
                comparatorDescription.addExtension("X-SCHEMA", values);
                comparatorDescription.setFqcn(comparator.getClass().getName());
                comparatorDescription.setNumericOid(id);
                comparatorRegistry.register(comparatorDescription, comparator);
                break;
            }
            case SYNTAX_CHECKER_PRODUCER: {
                SyntaxChecker syntaxChecker = (SyntaxChecker)schemaObject;
                SyntaxCheckerRegistry syntaxCheckerRegistry = registries.getSyntaxCheckerRegistry();
                SyntaxCheckerDescription syntaxCheckerDescription = new SyntaxCheckerDescription();
                syntaxCheckerDescription.addExtension("X-SCHEMA", values);
                syntaxCheckerDescription.setFqcn(syntaxChecker.getClass().getName());
                syntaxCheckerDescription.setNumericOid(id);
                syntaxCheckerRegistry.register(syntaxCheckerDescription, syntaxChecker);
                break;
            }
            case SYNTAX_PRODUCER: {
                Syntax syntax = (Syntax)schemaObject;
                if (schemaObject instanceof AbstractBootstrapProducer.BootstrapSyntax) {
                    ((AbstractBootstrapProducer.BootstrapSyntax)syntax).setSchema(schema.getSchemaName());
                }
                SyntaxRegistry syntaxRegistry = registries.getSyntaxRegistry();
                syntaxRegistry.register(syntax);
                break;
            }
            case MATCHING_RULE_PRODUCER: {
                MatchingRule matchingRule = (MatchingRule)schemaObject;
                if (schemaObject instanceof AbstractBootstrapProducer.BootstrapMatchingRule) {
                    ((AbstractBootstrapProducer.BootstrapMatchingRule)matchingRule).setSchema(schema.getSchemaName());
                }
                MatchingRuleRegistry matchingRuleRegistry = registries.getMatchingRuleRegistry();
                matchingRuleRegistry.register(matchingRule);
                break;
            }
            case ATTRIBUTE_TYPE_PRODUCER: {
                AttributeType attributeType = (AttributeType)schemaObject;
                if (attributeType instanceof AbstractBootstrapProducer.BootstrapAttributeType) {
                    ((AbstractBootstrapProducer.BootstrapAttributeType)attributeType).setSchema(schema.getSchemaName());
                }
                AttributeTypeRegistry attributeTypeRegistry = registries.getAttributeTypeRegistry();
                attributeTypeRegistry.register(attributeType);
                break;
            }
            case OBJECT_CLASS_PRODUCER: {
                ObjectClass objectClass = (ObjectClass)schemaObject;
                if (objectClass instanceof AbstractBootstrapProducer.BootstrapObjectClass) {
                    ((AbstractBootstrapProducer.BootstrapObjectClass)objectClass).setSchema(schema.getSchemaName());
                }
                ObjectClassRegistry objectClassRegistry = registries.getObjectClassRegistry();
                objectClassRegistry.register(objectClass);
                break;
            }
            default: {
                throw new IllegalStateException("ProducerTypeEnum value is invalid: " + type);
            }
        }
    }

    private BootstrapProducer getProducer(BootstrapSchema schema, String producerBase) throws NamingException {
        Class<?> clazz = null;
        boolean failedTargetLoad = false;
        String targetClassName = schema.getBaseClassName() + producerBase;
        try {
            clazz = Class.forName(targetClassName, true, this.cl);
        }
        catch (ClassNotFoundException e) {
            failedTargetLoad = true;
            log.debug("Failed to load '" + targetClassName + "'.  Trying the alternative.", (Throwable)e);
        }
        if (failedTargetLoad) {
            String defaultClassName = schema.getDefaultBaseClassName() + producerBase;
            try {
                clazz = Class.forName(defaultClassName, true, this.cl);
            }
            catch (ClassNotFoundException e) {
                NamingException ne = new NamingException("Failed to load " + producerBase + " for " + schema.getSchemaName() + " schema using following classes: " + targetClassName + ", " + defaultClassName);
                ne.setRootCause(e);
                throw ne;
            }
        }
        try {
            return (BootstrapProducer)clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            NamingException ne = new NamingException("Failed to create " + clazz);
            ne.setRootCause(e);
            throw ne;
        }
        catch (InstantiationException e) {
            NamingException ne = new NamingException("Failed to create " + clazz);
            ne.setRootCause(e);
            throw ne;
        }
    }

    public Schema getSchema(String schemaName) throws NamingException {
        return this.getSchema(schemaName, null);
    }

    public Schema getSchema(String schemaName, Properties schemaProperties) throws NamingException {
        String baseName = schemaName;
        schemaName = schemaName.toLowerCase();
        StringBuffer buf = new StringBuffer();
        if (schemaProperties == null || schemaProperties.getProperty("package") == null) {
            Properties props = new Properties();
            props.put("package", "org.apache.directory.server.schema.bootstrap");
            try {
                Schema schema = this.getSchema(baseName, props);
                return schema;
            }
            catch (NamingException e) {
                throw new NamingException("Can't find the bootstrap schema class in the default \n bootstrap schema package.  I need a package name property with key \"package\".");
            }
        }
        buf.append(schemaProperties.getProperty("package"));
        buf.append('.');
        buf.append(Character.toUpperCase(schemaName.charAt(0)));
        buf.append(schemaName.substring(1));
        schemaName = buf.toString();
        Schema schema = null;
        try {
            schema = (Schema)Class.forName(schemaName, true, this.cl).newInstance();
        }
        catch (InstantiationException e) {
            NamingException ne = new NamingException("Failed to instantiate schema object: " + schemaName);
            ne.setRootCause(e);
            throw ne;
        }
        catch (IllegalAccessException e) {
            NamingException ne = new NamingException("Failed to access default constructor of schema object: " + schemaName);
            ne.setRootCause(e);
            throw ne;
        }
        catch (ClassNotFoundException e) {
            NamingException ne = new NamingException("Schema class not found: " + schemaName);
            ne.setRootCause(e);
            throw ne;
        }
        return schema;
    }
}

