/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.apache.directory.server.protocol.shared.store.LdifLoadFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdifFileLoader {
    private static final Logger log;
    protected DirContext ctx;
    protected File ldif;
    protected final List filters;
    protected final ClassLoader loader;
    private int count;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.directory.server.protocol.shared.store.LdifFileLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public LdifFileLoader(DirContext ctx, String ldif) {
        this(ctx, new File(ldif), null);
    }

    public LdifFileLoader(DirContext ctx, File ldif, List filters) {
        this(ctx, ldif, filters, null);
    }

    public LdifFileLoader(DirContext ctx, File ldif, List filters, ClassLoader loader) {
        this.ctx = ctx;
        this.ldif = ldif;
        this.loader = loader;
        this.filters = filters == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(filters);
    }

    private boolean applyFilters(String dn, Attributes entry) {
        boolean accept = true;
        int limit = this.filters.size();
        if (limit == 0) {
            return true;
        }
        int ii = 0;
        while (ii < limit) {
            try {
                accept &= ((LdifLoadFilter)this.filters.get(ii)).filter(this.ldif, dn, entry, this.ctx);
            }
            catch (NamingException e) {
                log.warn("filter " + this.filters.get(ii) + " was bypassed due to failures", (Throwable)e);
            }
            if (!accept) {
                return false;
            }
            ++ii;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public int execute() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 233->236)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Name getRelativeName(DirContext ctx, String baseDn) throws NamingException {
        CompoundName searchBaseDn;
        Properties props = new Properties();
        props.setProperty("jndi.syntax.direction", "right_to_left");
        props.setProperty("jndi.syntax.separator", ",");
        props.setProperty("jndi.syntax.ignorecase", "true");
        props.setProperty("jndi.syntax.trimblanks", "true");
        try {
            CompoundName ctxRoot = new CompoundName(ctx.getNameInNamespace(), props);
            searchBaseDn = new CompoundName(baseDn, props);
            if (!searchBaseDn.startsWith(ctxRoot)) {
                throw new NamingException("Invalid search base " + baseDn);
            }
            int ii = 0;
            while (ii < ctxRoot.size()) {
                searchBaseDn.remove(0);
                ++ii;
            }
        }
        catch (NamingException e) {
            throw new NamingException("Failed to initialize search base " + baseDn);
        }
        return searchBaseDn;
    }

    private InputStream getLdifStream() throws FileNotFoundException {
        if (!this.ldif.exists()) {
            InputStream in;
            if (this.loader != null && (in = this.loader.getResourceAsStream(this.ldif.getName())) != null) {
                return in;
            }
            in = this.getClass().getResourceAsStream(this.ldif.getName());
            if (in != null) {
                return in;
            }
            in = ClassLoader.getSystemResourceAsStream(this.ldif.getName());
            if (in != null) {
                return in;
            }
            throw new FileNotFoundException("LDIF file does not exist.");
        }
        FileInputStream in = new FileInputStream(this.ldif);
        return in;
    }
}

