/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind.plain;

import java.io.IOException;
import javax.naming.InvalidNameException;
import javax.security.sasl.SaslException;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.bind.AbstractSaslServer;
import org.apache.directory.shared.ldap.model.message.BindRequest;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.PrepareString;
import org.apache.directory.shared.util.StringConstants;
import org.apache.directory.shared.util.Strings;

public class PlainSaslServer
extends AbstractSaslServer {
    public static final String SASL_PLAIN_AUTHZID = "authzid";
    public static final String SASL_PLAIN_AUTHCID = "authcid";
    public static final String SASL_PLAIN_PASSWORD = "password";
    private NegotiationState state = NegotiationState.INITIALIZED;

    public PlainSaslServer(LdapSession ldapSession, CoreSession adminSession, BindRequest bindRequest) {
        super(ldapSession, adminSession, bindRequest);
        this.getLdapSession().removeSaslProperty(SASL_PLAIN_AUTHZID);
        this.getLdapSession().removeSaslProperty(SASL_PLAIN_AUTHCID);
        this.getLdapSession().removeSaslProperty(SASL_PLAIN_PASSWORD);
    }

    @Override
    public String getMechanismName() {
        return "PLAIN";
    }

    @Override
    public byte[] evaluateResponse(byte[] initialResponse) throws SaslException {
        if (Strings.isEmpty((byte[])initialResponse)) {
            this.state = NegotiationState.MECH_RECEIVED;
            return null;
        }
        InitialResponse element = InitialResponse.AUTHZID_EXPECTED;
        String authzId = null;
        String authcId = null;
        String password = null;
        int start = 0;
        int end = 0;
        try {
            for (byte b : initialResponse) {
                if (b == 0) {
                    if (start - end == 0) {
                        if (element == InitialResponse.AUTHZID_EXPECTED) {
                            element = InitialResponse.AUTHCID_EXPECTED;
                            continue;
                        }
                        throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_671, (Object[])new Object[0]));
                    }
                    String value = new String(initialResponse, ++start, end - start + 1, "UTF-8");
                    switch (element) {
                        case AUTHZID_EXPECTED: {
                            element = InitialResponse.AUTHCID_EXPECTED;
                            authzId = PrepareString.normalize((String)value, (PrepareString.StringType)PrepareString.StringType.CASE_EXACT_IA5);
                            start = ++end;
                            break;
                        }
                        case AUTHCID_EXPECTED: {
                            element = InitialResponse.PASSWORD_EXPECTED;
                            authcId = PrepareString.normalize((String)value, (PrepareString.StringType)PrepareString.StringType.DIRECTORY_STRING);
                            start = ++end;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_672, (Object[])new Object[0]));
                        }
                    }
                    continue;
                }
                ++end;
            }
            if (start == end) {
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_671, (Object[])new Object[0]));
            }
            String value = Strings.utf8ToString((byte[])initialResponse, (int)(++start), (int)(end - start + 1));
            password = PrepareString.normalize((String)value, (PrepareString.StringType)PrepareString.StringType.CASE_EXACT_IA5);
            if (authcId == null || password == null) {
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_671, (Object[])new Object[0]));
            }
            CoreSession userSession = this.authenticate(authcId, password);
            this.getLdapSession().setCoreSession(userSession);
            this.state = NegotiationState.COMPLETED;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_674, (Object[])new Object[0]));
        }
        catch (InvalidNameException ine) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_675, (Object[])new Object[0]));
        }
        catch (Exception e) {
            throw new SaslException(I18n.err((I18n)I18n.ERR_676, (Object[])new Object[]{authcId}));
        }
        return StringConstants.EMPTY_BYTES;
    }

    @Override
    public boolean isComplete() {
        return this.state == NegotiationState.COMPLETED;
    }

    private CoreSession authenticate(String user, String password) throws InvalidNameException, Exception {
        BindOperationContext bindContext = new BindOperationContext(this.getLdapSession().getCoreSession());
        bindContext.setDn(new Dn(new String[]{user}));
        bindContext.setCredentials(Strings.getBytesUtf8((String)password));
        this.getAdminSession().getDirectoryService().getOperationManager().bind(bindContext);
        return bindContext.getSession();
    }

    private static enum InitialResponse {
        AUTHZID_EXPECTED,
        AUTHCID_EXPECTED,
        PASSWORD_EXPECTED;

    }

    private static enum NegotiationState {
        INITIALIZED,
        MECH_RECEIVED,
        COMPLETED;

    }
}

