/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap;

import org.apache.commons.lang.StringUtils;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.ldap.LdapProtocolConstants;
import org.apache.directory.shared.ldap.model.csn.Csn;
import org.apache.directory.shared.ldap.model.message.Request;
import org.apache.directory.shared.ldap.model.message.Response;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapProtocolUtils {
    public static final String COOKIE_DELIM = ",";
    public static final String REPLICA_ID_PREFIX = "rid=";
    private static final int REPLICA_ID_PREFIX_LEN = "rid=".length();
    public static final String CSN_PREFIX = "csn=";
    private static final int CSN_PREFIX_LEN = "csn=".length();
    private static final Logger LOG = LoggerFactory.getLogger(LdapProtocolUtils.class);

    public static void setRequestControls(OperationContext opContext, Request request) throws Exception {
        if (request.getControls() != null) {
            request.addAllControls(request.getControls().values().toArray(LdapProtocolConstants.EMPTY_CONTROLS));
        }
    }

    public static void setResponseControls(OperationContext opContext, Response response) throws Exception {
        opContext.addRequestControls(opContext.getResponseControls());
    }

    public static byte[] createCookie(int replicaId, String csn) {
        String replicaIdStr = StringUtils.leftPad((String)Integer.toString(replicaId), (int)3, (char)'0');
        return Strings.getBytesUtf8((String)(REPLICA_ID_PREFIX + replicaIdStr + COOKIE_DELIM + CSN_PREFIX + csn));
    }

    public static boolean isValidCookie(String cookieString) {
        if (cookieString == null || cookieString.trim().length() == 0) {
            return false;
        }
        int pos = cookieString.indexOf(COOKIE_DELIM);
        if (pos <= REPLICA_ID_PREFIX_LEN) {
            return false;
        }
        String replicaId = cookieString.substring(REPLICA_ID_PREFIX_LEN, pos);
        try {
            Integer.parseInt(replicaId);
        }
        catch (NumberFormatException e) {
            LOG.debug("Failed to parse the replica id {}", (Object)replicaId);
            return false;
        }
        if (pos == cookieString.length()) {
            return false;
        }
        String csnString = cookieString.substring(pos + 1 + CSN_PREFIX_LEN);
        return Csn.isValid((String)csnString);
    }

    public static String getCsn(String cookieString) {
        int pos = cookieString.indexOf(COOKIE_DELIM);
        return cookieString.substring(pos + 1 + CSN_PREFIX_LEN);
    }

    public static int getReplicaId(String cookieString) {
        String replicaId = cookieString.substring(REPLICA_ID_PREFIX_LEN, cookieString.indexOf(COOKIE_DELIM));
        return Integer.parseInt(replicaId);
    }
}

