/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import jdbm.helper.Serializer;
import org.apache.directory.server.core.partition.impl.btree.jdbm.EntrySerializer;
import org.apache.directory.server.ldap.replication.ReplicaEventMessage;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.shared.ldap.extras.controls.SyncModifyDn;
import org.apache.directory.shared.ldap.extras.controls.SyncModifyDnType;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncModifyDnDecorator;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.message.controls.ChangeType;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

public class ReplicaEventMessageSerializer
implements Serializer {
    private static final long serialVersionUID = 1L;
    private transient EntrySerializer entrySerializer;
    private transient LdapApiService codec = LdapApiServiceFactory.getSingleton();
    private transient SchemaManager schemaManager;

    public ReplicaEventMessageSerializer(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.entrySerializer = new EntrySerializer(schemaManager);
    }

    public byte[] serialize(Object object) throws IOException {
        ReplicaEventMessage replicaEventMessage = (ReplicaEventMessage)object;
        Entry entry = replicaEventMessage.getEntry();
        ChangeType changeType = replicaEventMessage.getChangeType();
        SyncModifyDn modDnControl = replicaEventMessage.getModDnControl();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        entry.getDn().writeExternal((ObjectOutput)out);
        byte[] data = this.entrySerializer.serialize((Object)entry);
        out.writeInt(data.length);
        out.write(data);
        out.writeByte(changeType.getValue());
        if (changeType == ChangeType.MODDN) {
            SyncModifyDnType modDnType = modDnControl.getModDnType();
            out.writeByte(modDnType.getValue());
            switch (modDnType) {
                case MOVE: {
                    out.writeUTF(modDnControl.getNewSuperiorDn());
                    break;
                }
                case MOVE_AND_RENAME: {
                    out.writeUTF(modDnControl.getNewSuperiorDn());
                }
                case RENAME: {
                    out.writeUTF(modDnControl.getNewRdn());
                    out.writeBoolean(modDnControl.isDeleteOldRdn());
                }
            }
        }
        out.flush();
        return baos.toByteArray();
    }

    public Object deserialize(byte[] bytes) throws IOException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        ReplicaEventMessage replicaEventMessage = null;
        try {
            Dn entryDn = new Dn(this.schemaManager);
            entryDn.readExternal((ObjectInput)in);
            int length = in.readInt();
            byte[] data = new byte[length];
            in.read(data);
            Entry entry = (Entry)this.entrySerializer.deserialize(data);
            entry.setDn(entryDn);
            byte type = in.readByte();
            ChangeType changeType = ChangeType.getChangeType((int)type);
            if (changeType == ChangeType.MODDN) {
                type = in.readByte();
                SyncModifyDnType modDnType = SyncModifyDnType.getModifyDnType((int)type);
                SyncModifyDnDecorator modDnControl = new SyncModifyDnDecorator(this.codec);
                modDnControl.setModDnType(modDnType);
                switch (modDnType) {
                    case MOVE: {
                        modDnControl.setNewSuperiorDn(in.readUTF());
                        break;
                    }
                    case MOVE_AND_RENAME: {
                        modDnControl.setNewSuperiorDn(in.readUTF());
                    }
                    case RENAME: {
                        modDnControl.setNewRdn(in.readUTF());
                        modDnControl.setDeleteOldRdn(in.readBoolean());
                    }
                }
                replicaEventMessage = new ReplicaEventMessage((SyncModifyDn)modDnControl, entry);
            } else {
                replicaEventMessage = new ReplicaEventMessage(changeType, entry);
            }
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        return replicaEventMessage;
    }
}

