/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.extended;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.api.ldap.extras.extended.whoAmI.WhoAmIRequest;
import org.apache.directory.api.ldap.extras.extended.whoAmI.WhoAmIResponse;
import org.apache.directory.api.ldap.extras.extended.whoAmI.WhoAmIResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhoAmIHandler
implements ExtendedOperationHandler<WhoAmIRequest, WhoAmIResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(WhoAmIHandler.class);
    public static final Set<String> EXTENSION_OIDS;

    @Override
    public String getOid() {
        return "1.3.6.1.4.1.4203.1.11.3";
    }

    @Override
    public void handleExtendedOperation(LdapSession requestor, WhoAmIRequest req) throws Exception {
        LOG.debug("WhoAmI requested");
        LdapPrincipal ldapPrincipal = requestor.getCoreSession().getAuthenticatedPrincipal();
        WhoAmIResponseImpl whoAmIResponse = new WhoAmIResponseImpl(req.getMessageId(), ResultCodeEnum.SUCCESS);
        String authzId = "dn:" + ldapPrincipal.getDn();
        whoAmIResponse.setAuthzId(Strings.getBytesUtf8((String)authzId));
        requestor.getIoSession().write((Object)whoAmIResponse);
    }

    @Override
    public Set<String> getExtensionOids() {
        return EXTENSION_OIDS;
    }

    @Override
    public void setLdapServer(LdapServer ldapServer) {
    }

    static {
        HashSet<String> set = new HashSet<String>(2);
        set.add("1.3.6.1.4.1.4203.1.11.3");
        set.add("1.3.6.1.4.1.4203.1.11.3");
        EXTENSION_OIDS = Collections.unmodifiableSet(set);
    }
}

