/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication;

import java.util.Iterator;
import org.apache.activemq.ActiveMQQueueBrowser;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.directory.server.ldap.replication.ReplicaEventMessage;
import org.apache.directory.shared.ldap.model.cursor.AbstractCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReplicaEventLogCursor
extends AbstractCursor<ReplicaEventMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicaEventLogCursor.class);
    private ActiveMQQueueBrowser browser;
    private Queue regionQueue;

    public ReplicaEventLogCursor(ActiveMQSession session, ActiveMQQueue queue, Queue regionQueue) throws Exception {
        this.browser = (ActiveMQQueueBrowser)session.createBrowser((javax.jms.Queue)queue);
        this.regionQueue = regionQueue;
    }

    public void after(ReplicaEventMessage arg0) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void afterLast() throws Exception {
        throw new UnsupportedOperationException();
    }

    public boolean available() {
        return this.browser.hasMoreElements();
    }

    public void before(ReplicaEventMessage arg0) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void beforeFirst() throws Exception {
    }

    public boolean first() throws Exception {
        throw new UnsupportedOperationException();
    }

    public ReplicaEventMessage get() throws Exception {
        ActiveMQObjectMessage amqObj = (ActiveMQObjectMessage)this.browser.nextElement();
        LOG.debug("ReplicaEventMessage: {}", (Object)amqObj);
        ReplicaEventMessage message = (ReplicaEventMessage)amqObj.getObject();
        this.regionQueue.removeMessage(amqObj.getJMSMessageID());
        return message;
    }

    public boolean last() throws Exception {
        throw new UnsupportedOperationException();
    }

    public boolean next() throws Exception {
        return this.browser.hasMoreElements();
    }

    public boolean previous() throws Exception {
        throw new UnsupportedOperationException();
    }

    public void close() throws Exception {
        this.browser.close();
        super.close();
    }

    public void close(Exception cause) throws Exception {
        this.browser.close();
        super.close(cause);
    }

    public Iterator<ReplicaEventMessage> iterator() {
        throw new UnsupportedOperationException();
    }
}

