/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.exception.LdapOperationException;
import org.apache.directory.shared.ldap.exception.LdapReferralException;
import org.apache.directory.shared.ldap.message.BindRequestImpl;
import org.apache.directory.shared.ldap.message.BindResponseImpl;
import org.apache.directory.shared.ldap.message.ReferralImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.internal.InternalAbandonRequest;
import org.apache.directory.shared.ldap.message.internal.InternalBindRequest;
import org.apache.directory.shared.ldap.message.internal.InternalExtendedRequest;
import org.apache.directory.shared.ldap.message.internal.InternalLdapResult;
import org.apache.directory.shared.ldap.message.internal.InternalReferral;
import org.apache.directory.shared.ldap.message.internal.InternalRequest;
import org.apache.directory.shared.ldap.message.internal.InternalResultResponse;
import org.apache.directory.shared.ldap.message.internal.InternalResultResponseRequest;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.handler.demux.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LdapRequestHandler<T extends InternalRequest>
implements MessageHandler<T> {
    private static final Logger LOG = LoggerFactory.getLogger(LdapRequestHandler.class);
    protected LdapServer ldapServer;

    public final LdapServer getLdapServer() {
        return this.ldapServer;
    }

    public final void setLdapServer(LdapServer ldapServer) {
        this.ldapServer = ldapServer;
    }

    public final boolean isConfidentialityRequirementSatisfied(IoSession session) {
        if (!this.ldapServer.isConfidentialityRequired()) {
            return true;
        }
        IoFilterChain chain = session.getFilterChain();
        return chain.contains("sslFilter");
    }

    public void rejectWithoutConfidentiality(IoSession session, InternalResultResponse resp) {
        InternalLdapResult result = resp.getLdapResult();
        result.setResultCode(ResultCodeEnum.CONFIDENTIALITY_REQUIRED);
        result.setErrorMessage("Confidentiality (TLS secured connection) is required.");
        session.write((Object)resp);
    }

    public final void handleMessage(IoSession session, T message) throws Exception {
        LdapSession ldapSession = this.ldapServer.getLdapSessionManager().getLdapSession(session);
        if (ldapSession == null) {
            LOG.info("ignoring the message {} received from null session", message);
            return;
        }
        if (ldapSession.isAuthPending() && (!(message instanceof BindRequestImpl) || ((BindRequestImpl)message).isSimple() || ldapSession.isSimpleAuthPending())) {
            LOG.error(I18n.err((String)I18n.ERR_732, (Object[])new Object[0]));
            BindResponseImpl bindResponse = new BindResponseImpl(message.getMessageId());
            InternalLdapResult bindResult = bindResponse.getLdapResult();
            bindResult.setResultCode(ResultCodeEnum.UNWILLING_TO_PERFORM);
            bindResult.setErrorMessage(I18n.err((String)I18n.ERR_732, (Object[])new Object[0]));
            ldapSession.getIoSession().write((Object)bindResponse);
            return;
        }
        ldapSession.setLdapServer(this.ldapServer);
        if (!this.isConfidentialityRequirementSatisfied(session)) {
            if (message instanceof InternalExtendedRequest) {
                InternalExtendedRequest req = (InternalExtendedRequest)message;
                if (!req.getID().equals("1.3.6.1.4.1.1466.20037")) {
                    this.rejectWithoutConfidentiality(session, req.getResultResponse());
                    return;
                }
            } else {
                if (message instanceof InternalResultResponseRequest) {
                    this.rejectWithoutConfidentiality(session, ((InternalResultResponseRequest)message).getResultResponse());
                    return;
                }
                return;
            }
        }
        if (!(message instanceof InternalBindRequest)) {
            CoreSession coreSession = null;
            if (ldapSession.isAuthenticated()) {
                coreSession = ldapSession.getCoreSession();
                this.handle(ldapSession, message);
                return;
            }
            coreSession = this.getLdapServer().getDirectoryService().getSession();
            ldapSession.setCoreSession(coreSession);
            if (message instanceof InternalAbandonRequest) {
                return;
            }
            this.handle(ldapSession, message);
            return;
        }
        this.handle(ldapSession, message);
    }

    public abstract void handle(LdapSession var1, T var2) throws Exception;

    public void handleException(LdapSession session, InternalResultResponseRequest req, Exception e) {
        InternalLdapResult result = req.getResultResponse().getLdapResult();
        ResultCodeEnum code = e instanceof LdapOperationException ? ((LdapOperationException)e).getResultCode() : ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
        result.setResultCode(code);
        String msg = code.toString() + ": failed for " + req + ": " + e.getLocalizedMessage();
        if (LOG.isDebugEnabled()) {
            LOG.debug(msg, (Throwable)e);
            msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
        }
        result.setErrorMessage(msg);
        if (e instanceof LdapOperationException) {
            boolean setMatchedDn;
            LdapOperationException ne = (LdapOperationException)e;
            boolean bl = setMatchedDn = code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM;
            if (ne.getResolvedDn() != null && setMatchedDn) {
                result.setMatchedDn(ne.getResolvedDn());
            }
            if (e instanceof LdapReferralException) {
                ReferralImpl referrals = new ReferralImpl();
                do {
                    String ref = ((LdapReferralException)e).getReferralInfo();
                    referrals.addLdapUrl(ref);
                } while (((LdapReferralException)e).skipReferral());
                result.setReferral((InternalReferral)referrals);
            }
        }
        session.getIoSession().write((Object)req.getResultResponse());
    }
}

