/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap;

import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.shared.asn1.codec.Asn1CodecDecoder;
import org.apache.directory.shared.asn1.codec.Asn1CodecEncoder;
import org.apache.directory.shared.asn1.codec.stateful.StatefulDecoder;
import org.apache.directory.shared.asn1.codec.stateful.StatefulEncoder;
import org.apache.directory.shared.ldap.message.MessageDecoder;
import org.apache.directory.shared.ldap.message.MessageEncoder;
import org.apache.directory.shared.ldap.message.spi.BinaryAttributeDetector;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.util.StringTools;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;

final class LdapProtocolCodecFactory
implements ProtocolCodecFactory {
    private final DirectoryService directoryService;
    public static final String MAX_PDU_SIZE = "MAX_PDU_SIZE";

    public LdapProtocolCodecFactory(DirectoryService directoryService) {
        this.directoryService = directoryService;
    }

    public ProtocolEncoder getEncoder(IoSession session) {
        return new Asn1CodecEncoder((StatefulEncoder)new MessageEncoder());
    }

    public ProtocolDecoder getDecoder(IoSession session) {
        return new Asn1CodecDecoder((StatefulDecoder)new MessageDecoder(new BinaryAttributeDetector(){

            public boolean isBinary(String id) {
                SchemaManager schemaManager = LdapProtocolCodecFactory.this.directoryService.getSchemaManager();
                try {
                    AttributeType type = schemaManager.lookupAttributeTypeRegistry(id);
                    return !type.getSyntax().isHumanReadable();
                }
                catch (Exception e) {
                    if (StringTools.isEmpty((String)id)) {
                        return false;
                    }
                    return id.endsWith(";binary");
                }
            }
        }, this.directoryService.getMaxPDUSize()));
    }
}

