/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.shared.ldap.message.ExtendedRequest;
import org.apache.directory.shared.ldap.message.ExtendedResponse;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.util.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedHandler
extends LdapRequestHandler<ExtendedRequest> {
    @Override
    public void handle(LdapSession session, ExtendedRequest req) throws Exception {
        ExtendedOperationHandler handler = this.getLdapServer().getExtendedOperationHandler(req.getOid());
        if (handler == null) {
            String msg = "Unrecognized extended operation EXTENSION_OID: " + req.getOid();
            LdapResult result = req.getResultResponse().getLdapResult();
            result.setResultCode(ResultCodeEnum.PROTOCOL_ERROR);
            result.setErrorMessage(msg);
            session.getIoSession().write((Object)req.getResultResponse());
            return;
        }
        try {
            handler.handleExtendedOperation(session, req);
        }
        catch (Exception e) {
            LdapResult result = req.getResultResponse().getLdapResult();
            result.setResultCode(ResultCodeEnum.OTHER);
            result.setErrorMessage(ResultCodeEnum.OTHER + ": Extended operation handler for the specified EXTENSION_OID (" + req.getOid() + ") has failed to process your request:\n" + ExceptionUtils.getStackTrace((Throwable)e));
            ExtendedResponse resp = (ExtendedResponse)req.getResultResponse();
            resp.setResponse(new byte[0]);
            session.getIoSession().write((Object)req.getResultResponse());
        }
    }
}

