/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.ldap.handlers.AddHandler;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.AddRequest;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.Message;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.Referral;
import org.apache.directory.shared.ldap.message.ReferralImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAddHandler
extends AddHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AddHandler.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    protected void addMessageReceived(IoSession session, AddRequest req) throws Exception {
        LdapResult result = req.getResultResponse().getLdapResult();
        if (IS_DEBUG) {
            LOG.debug("Received an Add message:  {}", (Object)req.toString());
        }
        try {
            if (!this.isConfidentialityRequirementSatisfied(session)) {
                result.setResultCode(ResultCodeEnum.CONFIDENTIALITY_REQUIRED);
                result.setErrorMessage("Confidentiality (TLS secured connection) is required.");
                session.write((Object)req.getResultResponse());
                return;
            }
            LdapContext ctx = this.getSessionRegistry().getLdapContext(session, null, true);
            if (req.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
                ctx.addToEnvironment("java.naming.referral", "ignore");
            } else {
                ctx.addToEnvironment("java.naming.referral", "throw");
            }
            this.setRequestControls(ctx, (Message)req);
            ctx.createSubcontext((Name)req.getEntry(), req.getAttributes());
            result.setResultCode(ResultCodeEnum.SUCCESS);
            req.getResultResponse().addAll(ctx.getResponseControls());
            session.write((Object)req.getResultResponse());
        }
        catch (ReferralException e) {
            ReferralImpl refs = new ReferralImpl();
            result.setReferral((Referral)refs);
            result.setResultCode(ResultCodeEnum.REFERRAL);
            result.setErrorMessage("Encountered referral attempting to handle add request.");
            do {
                refs.addLdapUrl((String)e.getReferralInfo());
            } while (e.skipReferral());
            session.write((Object)req.getResultResponse());
        }
        catch (NamingException e) {
            String msg = "failed to add entry " + req.getEntry() + ": " + e.getMessage();
            if (LOG.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
            }
            ResultCodeEnum code = e instanceof LdapException ? ((LdapException)e).getResultCode() : ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
            result.setResultCode(code);
            result.setErrorMessage(msg);
            if (e.getResolvedName() != null && (code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM)) {
                result.setMatchedDn((LdapDN)e.getResolvedName());
            }
            session.write((Object)req.getResultResponse());
        }
    }
}

