/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support.ssl;

import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import javax.naming.NamingException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.directory.server.ldap.support.ssl.ServerX509TrustManager;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.filter.SSLFilter;

public class LdapsInitializer {
    public static IoFilterChainBuilder init(KeyStore ks) throws NamingException {
        SSLContext sslCtx;
        try {
            String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
            if (algorithm == null) {
                algorithm = "SunX509";
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, null);
            sslCtx = SSLContext.getInstance("TLS");
            sslCtx.init(kmf.getKeyManagers(), new TrustManager[]{new ServerX509TrustManager()}, new SecureRandom());
        }
        catch (Exception e) {
            throw (NamingException)new NamingException("Failed to create a SSL context.").initCause(e);
        }
        DefaultIoFilterChainBuilder chain = new DefaultIoFilterChainBuilder();
        chain.addLast("SSL", (IoFilter)new SSLFilter(sslCtx));
        return chain;
    }
}

