/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.store.jndi;

import java.util.Set;
import javax.naming.directory.DirContext;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.dns.DnsException;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.directory.server.dns.store.jndi.SearchStrategy;
import org.apache.directory.server.dns.store.jndi.operations.GetRecords;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.protocol.shared.ServiceConfigurationException;
import org.apache.directory.shared.ldap.name.DN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleBaseSearch
implements SearchStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SingleBaseSearch.class);
    private final DirContext ctx;

    SingleBaseSearch(String searchBaseDn, DirectoryService directoryService) {
        try {
            CoreSession session = directoryService.getSession();
            this.ctx = new ServerLdapContext(directoryService, session, new DN(searchBaseDn));
        }
        catch (Exception e) {
            throw new ServiceConfigurationException(I18n.err((String)I18n.ERR_649, (Object[])new Object[]{searchBaseDn}), (Throwable)e);
        }
    }

    @Override
    public Set<ResourceRecord> getRecords(QuestionRecord question) throws DnsException {
        try {
            return new GetRecords(question).execute(this.ctx, null);
        }
        catch (Exception e) {
            LOG.debug("Unexpected error retrieving DNS records.", (Throwable)e);
            throw new DnsException(ResponseCode.SERVER_FAILURE);
        }
    }
}

