/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.messages;

import org.apache.directory.server.dns.messages.MessageType;
import org.apache.directory.server.dns.messages.OpCode;
import org.apache.directory.server.dns.messages.QuestionRecords;
import org.apache.directory.server.dns.messages.ResourceRecords;
import org.apache.directory.server.dns.messages.ResponseCode;

public class DnsMessage {
    private short transactionId;
    private MessageType messageType;
    private OpCode opCode;
    private boolean authoritativeAnswer;
    private boolean truncated;
    private boolean recursionDesired;
    private boolean recursionAvailable;
    private boolean reserved;
    private boolean acceptNonAuthenticatedData;
    private ResponseCode responseCode;
    private QuestionRecords questionRecords;
    private ResourceRecords answerRecords;
    private ResourceRecords authorityRecords;
    private ResourceRecords additionalRecords;

    public DnsMessage(short transactionId, MessageType messageType, OpCode opCode, boolean authoritativeAnswer, boolean truncated, boolean recursionDesired, boolean recursionAvailable, boolean reserved, boolean acceptNonAuthenticatedData, ResponseCode responseCode, QuestionRecords question, ResourceRecords answer, ResourceRecords authority, ResourceRecords additional) {
        this.transactionId = transactionId;
        this.messageType = messageType;
        this.opCode = opCode;
        this.authoritativeAnswer = authoritativeAnswer;
        this.truncated = truncated;
        this.recursionDesired = recursionDesired;
        this.recursionAvailable = recursionAvailable;
        this.reserved = reserved;
        this.acceptNonAuthenticatedData = acceptNonAuthenticatedData;
        this.responseCode = responseCode;
        this.questionRecords = question;
        this.answerRecords = answer;
        this.authorityRecords = authority;
        this.additionalRecords = additional;
    }

    public boolean isAcceptNonAuthenticatedData() {
        return this.acceptNonAuthenticatedData;
    }

    public ResourceRecords getAdditionalRecords() {
        return this.additionalRecords;
    }

    public ResourceRecords getAnswerRecords() {
        return this.answerRecords;
    }

    public boolean isAuthoritativeAnswer() {
        return this.authoritativeAnswer;
    }

    public ResourceRecords getAuthorityRecords() {
        return this.authorityRecords;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public OpCode getOpCode() {
        return this.opCode;
    }

    public QuestionRecords getQuestionRecords() {
        return this.questionRecords;
    }

    public boolean isRecursionAvailable() {
        return this.recursionAvailable;
    }

    public boolean isRecursionDesired() {
        return this.recursionDesired;
    }

    public boolean isReserved() {
        return this.reserved;
    }

    public ResponseCode getResponseCode() {
        return this.responseCode;
    }

    public short getTransactionId() {
        return this.transactionId;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public String toString() {
        return this.getClass().getName() + "[ transactionId = " + this.transactionId + " ]";
    }
}

