/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.store;

import java.util.Set;
import javax.naming.spi.InitialContextFactory;
import org.apache.directory.server.dns.DnsConfiguration;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.store.MultiBaseSearch;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.directory.server.dns.store.SearchStrategy;
import org.apache.directory.server.dns.store.SingleBaseSearch;

public class JndiRecordStoreImpl
implements RecordStore {
    private DnsConfiguration config;
    private InitialContextFactory factory;
    private SearchStrategy strategy;

    public JndiRecordStoreImpl(DnsConfiguration config, InitialContextFactory factory) {
        this.config = config;
        this.factory = factory;
        this.strategy = this.getSearchStrategy();
    }

    public Set getRecords(QuestionRecord question) throws Exception {
        return this.strategy.getRecords(question);
    }

    private SearchStrategy getSearchStrategy() {
        if (this.config.getCatalogBaseDn() != null) {
            return new MultiBaseSearch(this.config, this.factory);
        }
        return new SingleBaseSearch(this.config, this.factory);
    }
}

