/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dhcp.io;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.directory.server.dhcp.DhcpException;
import org.apache.directory.server.dhcp.options.DhcpOption;
import org.apache.directory.server.dhcp.options.OptionsField;
import org.apache.directory.server.dhcp.options.dhcp.DhcpMessageType;
import org.apache.directory.server.dhcp.options.dhcp.IpAddressLeaseTime;
import org.apache.directory.server.dhcp.options.dhcp.ParameterRequestList;
import org.apache.directory.server.dhcp.options.dhcp.RequestedIpAddress;
import org.apache.directory.server.dhcp.options.dhcp.ServerIdentifier;
import org.apache.directory.server.dhcp.options.vendor.DomainName;
import org.apache.directory.server.dhcp.options.vendor.DomainNameServers;
import org.apache.directory.server.dhcp.options.vendor.EndOption;
import org.apache.directory.server.dhcp.options.vendor.PadOption;
import org.apache.directory.server.dhcp.options.vendor.SubnetMask;
import org.apache.directory.server.dhcp.options.vendor.TimeOffset;

public class DhcpOptionsDecoder {
    private static final byte[] VENDOR_MAGIC_COOKIE = new byte[]{99, -126, 83, 99};

    public OptionsField decode(ByteBuffer message) throws DhcpException {
        byte[] magicCookie = new byte[4];
        message.get(magicCookie);
        if (!Arrays.equals(VENDOR_MAGIC_COOKIE, magicCookie)) {
            throw new DhcpException("Parse exception.");
        }
        OptionsField options = new OptionsField();
        while (message.get(message.position()) != -1) {
            byte code = message.get();
            byte length = message.get();
            byte[] value = new byte[length];
            message.get(value);
            options.add(this.getInstance(code, value));
        }
        return options;
    }

    private DhcpOption getInstance(int tag, byte[] value) throws DhcpException {
        switch (tag) {
            case 0: {
                return new PadOption();
            }
            case 1: {
                return new EndOption();
            }
            case 2: {
                return new SubnetMask(value);
            }
            case 3: {
                return new TimeOffset(value);
            }
            case 6: {
                return new DomainNameServers(value);
            }
            case 15: {
                return new DomainName(value);
            }
            case 50: {
                return new RequestedIpAddress(value);
            }
            case 51: {
                return new IpAddressLeaseTime(value);
            }
            case 53: {
                return new DhcpMessageType(value);
            }
            case 54: {
                return new ServerIdentifier(value);
            }
            case 55: {
                return new ParameterRequestList(value);
            }
        }
        throw new DhcpException("Unsupported or bad option code:  " + tag);
    }
}

