/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dhcp.io;

import java.nio.ByteBuffer;
import org.apache.directory.server.dhcp.DhcpException;
import org.apache.directory.server.dhcp.io.DhcpOptionsDecoder;
import org.apache.directory.server.dhcp.messages.DhcpMessage;
import org.apache.directory.server.dhcp.messages.DhcpMessageModifier;
import org.apache.directory.server.dhcp.messages.MessageType;

public class DhcpMessageDecoder {
    public DhcpMessage decode(ByteBuffer buffer) throws DhcpException {
        buffer.rewind();
        DhcpMessageModifier modifier = new DhcpMessageModifier();
        modifier.setMessageType(MessageType.DHCPDISCOVER);
        modifier.setOpCode(buffer.get());
        modifier.setHardwareAddressType(buffer.get());
        short hardwareAddressLength = (short)(buffer.get() & 0xFF);
        modifier.setHardwareAddressLength((byte)hardwareAddressLength);
        modifier.setHardwareOptions(buffer.get());
        modifier.setTransactionId(buffer.getInt());
        modifier.setSeconds(buffer.getShort());
        modifier.setFlags(buffer.getShort());
        byte[] nextFourBytes = new byte[4];
        buffer.get(nextFourBytes);
        modifier.setActualClientAddress(nextFourBytes);
        buffer.get(nextFourBytes);
        modifier.setAssignedClientAddress(nextFourBytes);
        buffer.get(nextFourBytes);
        modifier.setNextServerAddress(nextFourBytes);
        buffer.get(nextFourBytes);
        modifier.setRelayAgentAddress(nextFourBytes);
        byte[] clientHardwareAddress = new byte[16];
        buffer.get(clientHardwareAddress);
        modifier.setClientHardwareAddress(clientHardwareAddress);
        byte[] serverHostname = new byte[64];
        buffer.get(serverHostname);
        modifier.setServerHostname(serverHostname);
        byte[] bootFileName = new byte[128];
        buffer.get(bootFileName);
        modifier.setBootFileName(bootFileName);
        DhcpOptionsDecoder decoder = new DhcpOptionsDecoder();
        modifier.setOptions(decoder.decode(buffer));
        return modifier.getDhcpMessage();
    }
}

