/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store.operations;

import java.util.ArrayList;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerModification;
import org.apache.directory.server.kerberos.shared.store.operations.StoreUtils;
import org.apache.directory.server.protocol.shared.store.DirectoryServiceOperation;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.name.LdapDN;

public class ChangePassword
implements DirectoryServiceOperation {
    private static final long serialVersionUID = -7147685183641418353L;
    protected KerberosPrincipal principal;
    protected String newPassword;

    public ChangePassword(KerberosPrincipal principal, String newPassword) {
        this.principal = principal;
        this.newPassword = newPassword;
    }

    public Object execute(CoreSession session, LdapDN searchBaseDn) throws Exception {
        if (this.principal == null) {
            return null;
        }
        AttributeTypeRegistry registry = session.getDirectoryService().getRegistries().getAttributeTypeRegistry();
        ArrayList<ServerModification> mods = new ArrayList<ServerModification>(2);
        DefaultServerAttribute newPasswordAttribute = new DefaultServerAttribute(registry.lookup("2.5.4.35"), new String[]{this.newPassword});
        mods.set(0, new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, (EntryAttribute)newPasswordAttribute));
        DefaultServerAttribute principalAttribute = new DefaultServerAttribute(registry.lookup("krb5PrincipalName"), new String[]{this.principal.getName()});
        mods.set(1, new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, (EntryAttribute)principalAttribute));
        ServerEntry entry = StoreUtils.findPrincipalEntry(session, searchBaseDn, this.principal.getName());
        session.modify(entry.getDn(), mods);
        return entry.getDn();
    }
}

