/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptedDataEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.PrincipalNameEncoder;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class TicketEncoder {
    public static byte[] encodeTicket(Ticket ticket) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
        aos.writeObject((Object)TicketEncoder.encode(ticket));
        aos.close();
        return baos.toByteArray();
    }

    protected static DERApplicationSpecific encode(Ticket ticket) {
        DERSequence vector = new DERSequence();
        vector.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)DERInteger.valueOf((int)ticket.getTktVno())));
        vector.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)DERGeneralString.valueOf((String)ticket.getRealm())));
        vector.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)PrincipalNameEncoder.encode(ticket.getSName())));
        vector.add((DEREncodable)new DERTaggedObject(3, (DEREncodable)EncryptedDataEncoder.encodeSequence(ticket.getEncPart())));
        DERApplicationSpecific ticketSequence = null;
        try {
            ticketSequence = DERApplicationSpecific.valueOf((int)1, (DEREncodable)vector);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ticketSequence;
    }

    protected static DERSequence encodeSequence(Ticket[] tickets) {
        DERSequence outerVector = new DERSequence();
        for (int ii = 0; ii < tickets.length; ++ii) {
            DERSequence vector = new DERSequence();
            vector.add((DEREncodable)TicketEncoder.encode(tickets[ii]));
            outerVector.add((DEREncodable)vector);
        }
        return outerVector;
    }
}

