/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.decoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.KerberosMessageType;
import org.apache.directory.server.kerberos.shared.io.decoder.EncryptedDataDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.PreAuthenticationDataDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.PrincipalNameDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.TicketDecoder;
import org.apache.directory.server.kerberos.shared.messages.KdcReply;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosPrincipalModifier;
import org.apache.directory.server.kerberos.shared.messages.value.PaData;
import org.apache.directory.shared.asn1.der.ASN1InputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class KdcReplyDecoder {
    public KdcReply decode(ByteBuffer in) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(in);
        DERApplicationSpecific app = (DERApplicationSpecific)ais.readObject();
        DERSequence kdcreq = (DERSequence)app.getObject();
        return this.decodeKdcReplySequence(kdcreq);
    }

    private KdcReply decodeKdcReplySequence(DERSequence sequence) throws IOException {
        KerberosMessageType msgType = null;
        PaData[] paData = null;
        Ticket ticket = null;
        EncryptedData encPart = null;
        KerberosPrincipalModifier modifier = new KerberosPrincipalModifier();
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    break;
                }
                case 1: {
                    DERInteger tag1 = (DERInteger)derObject;
                    msgType = KerberosMessageType.getTypeByOrdinal(tag1.intValue());
                    break;
                }
                case 2: {
                    DERSequence tag2 = (DERSequence)derObject;
                    paData = PreAuthenticationDataDecoder.decodeSequence(tag2);
                    break;
                }
                case 3: {
                    DERGeneralString tag3 = (DERGeneralString)derObject;
                    modifier.setRealm(tag3.getString());
                    break;
                }
                case 4: {
                    DERSequence tag4 = (DERSequence)derObject;
                    modifier.setPrincipalName(PrincipalNameDecoder.decode(tag4));
                    break;
                }
                case 5: {
                    DERApplicationSpecific tag5 = (DERApplicationSpecific)derObject;
                    ticket = TicketDecoder.decode(tag5);
                    break;
                }
                case 6: {
                    DERSequence tag6 = (DERSequence)derObject;
                    encPart = EncryptedDataDecoder.decode(tag6);
                }
            }
        }
        KerberosPrincipal clientPrincipal = modifier.getKerberosPrincipal();
        return new KdcReply(paData, clientPrincipal, ticket, encPart, msgType);
    }
}

