/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.kerberos.shared.store.MultiBaseSearch;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.SingleBaseSearch;

public class JndiPrincipalStoreImpl
implements PrincipalStore {
    private final PrincipalStore store;

    public JndiPrincipalStoreImpl(String catalogBaseDn, String searchBaseDn, DirectoryService directoryService) {
        this.store = JndiPrincipalStoreImpl.getStore(catalogBaseDn, searchBaseDn, directoryService);
    }

    public String addPrincipal(PrincipalStoreEntry entry) throws Exception {
        return this.store.addPrincipal(entry);
    }

    public String deletePrincipal(KerberosPrincipal principal) throws Exception {
        return this.store.deletePrincipal(principal);
    }

    public PrincipalStoreEntry[] getAllPrincipals(String realm) throws Exception {
        return this.store.getAllPrincipals(realm);
    }

    public PrincipalStoreEntry getPrincipal(KerberosPrincipal principal) throws Exception {
        return this.store.getPrincipal(principal);
    }

    public String changePassword(KerberosPrincipal principal, String newPassword) throws Exception {
        return this.store.changePassword(principal, newPassword);
    }

    private static PrincipalStore getStore(String catalogBaseDn, String searchBaseDn, DirectoryService directoryService) {
        if (catalogBaseDn != null) {
            return new MultiBaseSearch(catalogBaseDn, directoryService);
        }
        return new SingleBaseSearch(searchBaseDn, directoryService);
    }
}

