/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.decoder;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.directory.server.kerberos.shared.io.decoder.Decoder;
import org.apache.directory.server.kerberos.shared.io.decoder.DecoderFactory;
import org.apache.directory.server.kerberos.shared.io.decoder.EncryptionKeyDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.KerberosTimeDecoder;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.components.EncApRepPart;
import org.apache.directory.server.kerberos.shared.messages.components.EncApRepPartModifier;
import org.apache.directory.shared.asn1.der.ASN1InputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERGeneralizedTime;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class EncApRepPartDecoder
implements Decoder,
DecoderFactory {
    public Decoder getDecoder() {
        return new EncApRepPartDecoder();
    }

    public Encodable decode(byte[] encodedEncApRepPart) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(encodedEncApRepPart);
        DERApplicationSpecific app = (DERApplicationSpecific)ais.readObject();
        DERSequence apRepPart = (DERSequence)app.getObject();
        return this.decodeEncApRepPartSequence(apRepPart);
    }

    private EncApRepPart decodeEncApRepPartSequence(DERSequence sequence) {
        EncApRepPartModifier modifier = new EncApRepPartModifier();
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERGeneralizedTime tag0 = (DERGeneralizedTime)derObject;
                    modifier.setClientTime(KerberosTimeDecoder.decode(tag0));
                    break;
                }
                case 1: {
                    DERInteger tag1 = (DERInteger)derObject;
                    modifier.setClientMicroSecond(new Integer(tag1.intValue()));
                    break;
                }
                case 2: {
                    DERSequence tag2 = (DERSequence)derObject;
                    modifier.setSubSessionKey(EncryptionKeyDecoder.decode(tag2));
                    break;
                }
                case 3: {
                    DERInteger tag3 = (DERInteger)derObject;
                    modifier.setSequenceNumber(new Integer(tag3.intValue()));
                }
            }
        }
        return modifier.getEncApRepPart();
    }
}

